/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record SendGeneralDataPacket(GeneralChunkData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendGeneralDataPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("send_general_data_packet"));
    public static final StreamCodec<FriendlyByteBuf, SendGeneralDataPacket> STREAM_CODEC = StreamCodec.composite(GeneralChunkData.STREAM_CODEC, SendGeneralDataPacket::data, SendGeneralDataPacket::new);

    public CustomPacketPayload.Type<SendGeneralDataPacket> type() {
        return TYPE;
    }

    public static void handle(SendGeneralDataPacket message, NetworkManager.PacketContext context) {
        context.queue(() -> FTBChunksClient.INSTANCE.updateGeneralData(message.data));
    }

    public static void send(ChunkTeamData teamData, ServerPlayer player) {
        SendGeneralDataPacket.send(teamData, List.of(player));
    }

    public static void send(ChunkTeamData teamData, Collection<ServerPlayer> players) {
        Collection<? extends ClaimedChunk> cc = teamData.getClaimedChunks();
        int loaded = (int)cc.stream().filter(ClaimedChunk::isForceLoaded).count();
        SendGeneralDataPacket data = new SendGeneralDataPacket(new GeneralChunkData(cc.size(), loaded, teamData.getMaxClaimChunks(), teamData.getMaxForceLoadChunks()));
        players.forEach(player -> teamData.getTeamManager().getTeamForPlayer(player).ifPresent(team -> {
            if (team.getId().equals(teamData.getTeam().getId())) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)data);
            }
        }));
    }

    public record GeneralChunkData(int claimed, int loaded, int maxClaimChunks, int maxForceLoadChunks) {
        public static StreamCodec<FriendlyByteBuf, GeneralChunkData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, GeneralChunkData::claimed, (StreamCodec)ByteBufCodecs.VAR_INT, GeneralChunkData::loaded, (StreamCodec)ByteBufCodecs.VAR_INT, GeneralChunkData::maxClaimChunks, (StreamCodec)ByteBufCodecs.VAR_INT, GeneralChunkData::maxForceLoadChunks, GeneralChunkData::new);
    }
}

