/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record StepFunction(float min, int steps, float step, float max) implements Float2FloatFunction
{
    @Deprecated(forRemoval=true, since="9.6.0")
    public static final Codec<StepFunction> STRICT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("min").forGetter(StepFunction::min), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("steps").forGetter(StepFunction::steps), (App)Codec.FLOAT.fieldOf("step").forGetter(StepFunction::step)).apply((Applicative)inst, StepFunction::new));
    public static final Codec<StepFunction> BOUNDS_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("min").forGetter(StepFunction::min), (App)Codec.FLOAT.fieldOf("max").forGetter(StepFunction::max), (App)Codec.FLOAT.optionalFieldOf("step", (Object)Float.valueOf(0.01f)).forGetter(StepFunction::step)).apply((Applicative)inst, StepFunction::fromBounds));
    public static final Codec<StepFunction> TRANSITION_CODEC = Codec.either(STRICT_CODEC, BOUNDS_CODEC).xmap(Either::unwrap, Either::right);
    public static final Codec<StepFunction> CONSTANT_CODEC = Codec.FLOAT.xmap(StepFunction::constant, StepFunction::min);
    public static final Codec<StepFunction> CODEC = Codec.either(CONSTANT_CODEC, TRANSITION_CODEC).xmap(Either::unwrap, StepFunction::toEither);
    public static final StreamCodec<ByteBuf, StepFunction> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, StepFunction::min, (StreamCodec)ByteBufCodecs.INT, StepFunction::steps, (StreamCodec)ByteBufCodecs.FLOAT, StepFunction::step, StepFunction::new);

    @Deprecated(forRemoval=true, since="9.6.0")
    public StepFunction(float min, int steps, float step) {
        this(min, steps, step, min + (float)steps * step);
    }

    public StepFunction(float min, int steps, float step, float max) {
        this.min = min;
        this.steps = steps;
        this.step = step;
        this.max = max;
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0, (Object)"Steps must be a positive integer");
        Preconditions.checkArgument((Math.abs(min + (float)steps * step - max) <= 1.0E-5f ? 1 : 0) != 0, (Object)"Max value is out-of-sync with other fields.");
    }

    public float get(float level) {
        return this.min + (float)((int)((float)this.steps * (level + 0.5f / (float)this.steps))) * this.step;
    }

    public int getInt(float level) {
        return (int)this.get(level);
    }

    public int getStep(float level) {
        return (int)((float)this.steps * (level + 0.5f / (float)this.steps));
    }

    public float getForStep(int step) {
        return this.min + this.step * (float)step;
    }

    public float getIntForStep(int step) {
        return (int)this.getForStep(step);
    }

    public boolean isConstant() {
        return this.step == 0.0f;
    }

    @Deprecated(forRemoval=true, since="9.8.2")
    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.min);
        buf.writeInt(this.steps);
        buf.writeFloat(this.step);
    }

    @Deprecated(forRemoval=true, since="9.8.2")
    public static StepFunction read(FriendlyByteBuf buf) {
        return new StepFunction(buf.readFloat(), buf.readInt(), buf.readFloat());
    }

    public static StepFunction fromBounds(float min, float max) {
        return StepFunction.fromBounds(min, max, 0.01f);
    }

    public static StepFunction fromBounds(float min, float max, float step) {
        if (min == max) {
            return StepFunction.constant(min);
        }
        int steps = Math.round((max - min) / step);
        if (Math.abs(min + step * (float)steps - max) > 1.0E-4f) {
            throw new UnsupportedOperationException("Failed to interpolate step function bounds with min=" + min + "; max=" + max + "; step=" + step + ". The step value must be a multiple of the difference between min and max.");
        }
        StepFunction function = new StepFunction(min, steps, step, max);
        return function;
    }

    public static StepFunction constant(float val) {
        return new StepFunction(val, 1, 0.0f, val);
    }

    private static Either<StepFunction, StepFunction> toEither(StepFunction function) {
        return function.isConstant() ? Either.left((Object)function) : Either.right((Object)function);
    }
}

