/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.exporter;

import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterTransferStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.MissingResourcesListeningExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.exporter.ExporterTransferQuotaProvider;
import com.ultramega.refinedtypes.type.source.SourceCapabilityCache;
import com.ultramega.refinedtypes.type.source.SourceInsertableStorage;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.util.function.ToLongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class SourceExporterTransferStrategyFactory
implements ExporterTransferStrategyFactory {
    public Class<? extends ResourceKey> getResourceType() {
        return SourceResource.class;
    }

    public ExporterTransferStrategy create(ServerLevel level, BlockPos pos, Direction direction, UpgradeState upgradeState, boolean fuzzyMode) {
        SourceCapabilityCache capabilityCache = new SourceCapabilityCache(level, pos, direction);
        SourceInsertableStorage destination = new SourceInsertableStorage(capabilityCache);
        long singleAmount = (long)(upgradeState.has((UpgradeItem)Items.INSTANCE.getStackUpgrade()) ? 64 : 1) * Platform.INSTANCE.getBucketAmount();
        ExporterTransferStrategy strategy = this.create(fuzzyMode, destination, (ToLongFunction<ResourceKey>)new ExporterTransferQuotaProvider(singleAmount, upgradeState, destination::getAmount, true));
        if (upgradeState.has((UpgradeItem)Items.INSTANCE.getAutocraftingUpgrade())) {
            return new MissingResourcesListeningExporterTransferStrategy(strategy, MissingResourcesListeningExporterTransferStrategy.OnMissingResources.scheduleAutocrafting((ToLongFunction)new ExporterTransferQuotaProvider(singleAmount, upgradeState, destination::getAmount, false)));
        }
        return strategy;
    }

    private ExporterTransferStrategy create(boolean fuzzyMode, SourceInsertableStorage destination, ToLongFunction<ResourceKey> transferQuotaProvider) {
        if (fuzzyMode) {
            return new ExporterTransferStrategyImpl((InsertableStorage)destination, transferQuotaProvider, FuzzyRootStorage.expander());
        }
        return new ExporterTransferStrategyImpl((InsertableStorage)destination, transferQuotaProvider);
    }
}

