/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.grid.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class EnergyGridInsertionStrategy
implements GridInsertionStrategy {
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;

    public EnergyGridInsertionStrategy(AbstractContainerMenu menu, ServerPlayer player, Grid grid) {
        this.menu = menu;
        this.gridOperations = grid.createOperations((ResourceType)EnergyResourceType.INSTANCE, player);
    }

    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        ILongEnergyStorage cursorStorage = this.getEnergyCursorStorage();
        if (cursorStorage == null) {
            return false;
        }
        long extractableResource = cursorStorage.getAmount();
        if (extractableResource <= 0L) {
            return false;
        }
        this.gridOperations.insert((ResourceKey)EnergyResource.createEnergyResource(), insertMode, (resource, amount, action, source) -> {
            if (!(resource instanceof EnergyResource)) {
                return 0L;
            }
            return cursorStorage.extract(amount, action == Action.SIMULATE);
        });
        return true;
    }

    @Nullable
    private ILongEnergyStorage getEnergyCursorStorage() {
        return this.getEnergyStorage(this.menu.getCarried());
    }

    @Nullable
    private ILongEnergyStorage getEnergyStorage(ItemStack stack) {
        return (ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM);
    }

    public boolean onTransfer(int slotIndex) {
        throw new UnsupportedOperationException();
    }
}

