/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.networkenergizer;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.packet.s2c.NetworkEnergizerEnergyInfoPacket;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NetworkEnergizerEnergyInfo {
    private final Player player;
    private final LongSupplier storedSupplier;
    private final LongSupplier capacitySupplier;
    private long stored;
    private long capacity;

    private NetworkEnergizerEnergyInfo(ServerPlayer player, LongSupplier storedSupplier, LongSupplier capacitySupplier) {
        this.player = player;
        this.storedSupplier = storedSupplier;
        this.capacitySupplier = capacitySupplier;
        this.stored = storedSupplier.getAsLong();
        this.capacity = capacitySupplier.getAsLong();
    }

    private NetworkEnergizerEnergyInfo(Player player, long stored, long capacity) {
        this.player = player;
        this.storedSupplier = () -> 0L;
        this.capacitySupplier = () -> 0L;
        this.stored = stored;
        this.capacity = capacity;
    }

    public void detectChanges() {
        boolean changed;
        long newStored = this.storedSupplier.getAsLong();
        long newCapacity = this.capacitySupplier.getAsLong();
        boolean bl = changed = this.stored != newStored || this.capacity != newCapacity;
        if (changed) {
            this.setEnergy(newStored, newCapacity);
            Platform.INSTANCE.sendPacketToClient((ServerPlayer)this.player, (CustomPacketPayload)new NetworkEnergizerEnergyInfoPacket(newStored, newCapacity));
        }
    }

    public void setEnergy(long newStored, long newCapacity) {
        this.stored = newStored;
        this.capacity = newCapacity;
    }

    public List<Component> createTooltip() {
        return Collections.singletonList(IdentifierUtil.createTranslation((String)"gui", (String)"autocrafting_preview.available", (Object[])new Object[]{Component.literal((String)(this.stored == Long.MAX_VALUE ? "\u221e" : IdentifierUtil.format((long)this.stored))).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY));
    }

    public double getPercentageFull() {
        return (double)this.stored / (double)this.capacity;
    }

    public static NetworkEnergizerEnergyInfo forServer(Player player, LongSupplier storedSupplier, LongSupplier capacitySupplier) {
        return new NetworkEnergizerEnergyInfo((ServerPlayer)player, storedSupplier, capacitySupplier);
    }

    public static NetworkEnergizerEnergyInfo forClient(Player player, long stored, long capacity) {
        return new NetworkEnergizerEnergyInfo(player, stored, capacity);
    }
}

