/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.energy;

import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.ultramega.refinedtypes.ModInitializer;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.BlockEntities;
import com.ultramega.refinedtypes.registry.Menus;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.type.energy.EnergyResourceFactory;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EnergyStorageBlockProvider
implements StorageBlockProvider {
    private final EnergyStorageVariant variant;
    private final Component displayName;

    public EnergyStorageBlockProvider(EnergyStorageVariant variant) {
        this.variant = variant;
        this.displayName = RefinedTypesUtil.createRefinedTypesTranslation("block", String.format("%s_energy_storage_block", variant.getName()));
    }

    public SerializableStorage createStorage(Runnable runnable) {
        return EnergyResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), runnable);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case EnergyStorageVariant.K_64 -> ModInitializer.getConfig().getEnergyStorageBlock().get64KEnergyUsage();
            case EnergyStorageVariant.K_256 -> ModInitializer.getConfig().getEnergyStorageBlock().get256KEnergyUsage();
            case EnergyStorageVariant.K_1024 -> ModInitializer.getConfig().getEnergyStorageBlock().get1024KEnergyUsage();
            case EnergyStorageVariant.K_8192 -> ModInitializer.getConfig().getEnergyStorageBlock().get8192KEnergyUsage();
            case EnergyStorageVariant.K_65536 -> ModInitializer.getConfig().getEnergyStorageBlock().get65536KEnergyUsage();
            case EnergyStorageVariant.K_262144 -> ModInitializer.getConfig().getEnergyStorageBlock().get262144KEnergyUsage();
            case EnergyStorageVariant.K_1048576 -> ModInitializer.getConfig().getEnergyStorageBlock().get1048576KEnergyUsage();
            case EnergyStorageVariant.K_8388608 -> ModInitializer.getConfig().getEnergyStorageBlock().get8388608KEnergyUsage();
            case EnergyStorageVariant.INFINITE -> ModInitializer.getConfig().getEnergyStorageBlock().getInfiniteEnergyUsage();
        };
    }

    public ResourceFactory getResourceFactory() {
        return EnergyResourceFactory.INSTANCE;
    }

    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntities.getEnergyStorageBlock(this.variant);
    }

    public MenuType<?> getMenuType() {
        return Menus.getEnergyStorage();
    }
}

