/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.energy;

import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Items;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public enum EnergyStorageVariant implements StringRepresentable,
StorageVariant
{
    K_64(64000L),
    K_256(256000L),
    K_1024(1024000L),
    K_8192(0x7D0000L),
    K_65536(65536000L),
    K_262144(0xFA00000L),
    K_1048576(1048576000L),
    K_8388608(8388608000L),
    INFINITE(null);

    private final String name;
    private final ResourceLocation storageDiskId;
    private final ResourceLocation storageBlockId;
    private final ResourceLocation storagePartId;
    @Nullable
    private final Long capacity;

    private EnergyStorageVariant(Long capacity) {
        this.name = capacity == null ? "infinite" : capacity / 1000L + "k";
        this.storagePartId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_energy_storage_part");
        this.storageDiskId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_energy_storage_disk");
        this.storageBlockId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_energy_storage_block");
        this.capacity = capacity;
    }

    @Nullable
    public Long getCapacity() {
        return this.capacity;
    }

    public Item getStoragePart() {
        return Items.getEnergyStoragePart(this);
    }

    public ResourceLocation getStorageDiskId() {
        return this.storageDiskId;
    }

    public ResourceLocation getStorageBlockId() {
        return this.storageBlockId;
    }

    public ResourceLocation getStoragePartId() {
        return this.storagePartId;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }
}

