/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.source;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.refinedtypes.type.source.SourceResource;
import com.ultramega.refinedtypes.type.source.SourceResourceType;
import net.minecraft.world.item.ItemStack;

public record ResourceContainerSourceHandlerAdapter(ResourceContainer container) implements ISourceCap
{
    public int receiveSource(int amount, boolean simulate) {
        for (int i = 0; i < this.container.size(); ++i) {
            int received;
            ResourceAmount currentResource = this.container.get(i);
            if (currentResource == null) {
                return (int)this.insertSourceInEmptySlot(i, amount, simulate);
            }
            if (!(currentResource.resource() instanceof SourceResource) || (received = (int)this.insertSourceInFilledSlot(i, amount, simulate, currentResource)) <= 0) continue;
            return received;
        }
        return 0;
    }

    private long insertSourceInFilledSlot(int index, long maxReceive, boolean simulate, ResourceAmount currentResource) {
        long currentAmount = currentResource.amount();
        long toInsert = Math.min(maxReceive, Math.max(this.container.getMaxAmount(currentResource.resource()), SourceResourceType.INSTANCE.getInterfaceExportLimit()) - currentAmount);
        if (toInsert <= 0L) {
            return 0L;
        }
        if (!simulate) {
            this.container.set(index, new ResourceAmount(currentResource.resource(), currentAmount + toInsert));
        }
        return toInsert;
    }

    private long insertSourceInEmptySlot(int tank, long maxReceive, boolean simulate) {
        long toInsert = Math.min(maxReceive, Math.max(this.container.getMaxAmount((ResourceKey)ItemResource.ofItemStack((ItemStack)ItemStack.EMPTY)), SourceResourceType.INSTANCE.getInterfaceExportLimit()));
        if (toInsert <= 0L) {
            return 0L;
        }
        if (!simulate) {
            this.container.set(tank, new ResourceAmount((ResourceKey)SourceResource.createSourceResource(), toInsert));
        }
        return toInsert;
    }

    public int extractSource(int drain, boolean simulate) {
        if (drain <= 0) {
            return 0;
        }
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resourceAmount = this.container.get(i);
            if (resourceAmount == null || !(resourceAmount.resource() instanceof SourceResource)) continue;
            long available = resourceAmount.amount();
            if (available <= 0L) {
                return 0;
            }
            int toExtract = (int)Math.min((long)drain, available);
            if (!simulate) {
                this.container.shrink(i, (long)toExtract);
            }
            return toExtract;
        }
        return 0;
    }

    public void setSource(int source) {
    }

    public int getSource() {
        long amount = 0L;
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resourceAmount = this.container.get(i);
            if (resourceAmount == null || !(resourceAmount.resource() instanceof SourceResource)) continue;
            amount += resourceAmount.amount();
        }
        return Math.clamp(amount, 0, Integer.MAX_VALUE);
    }

    public void setMaxSource(int max) {
    }

    public int getSourceCapacity() {
        long capacity = 0L;
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resource = this.container.get(i);
            if (resource != null && !(resource.resource() instanceof SourceResource)) continue;
            capacity += Math.max(this.container.getMaxAmount((ResourceKey)(resource != null ? resource.resource() : ItemResource.ofItemStack((ItemStack)ItemStack.EMPTY))), SourceResourceType.INSTANCE.getInterfaceExportLimit());
        }
        return Math.clamp(capacity, 0, Integer.MAX_VALUE);
    }

    public int getMaxExtract() {
        return Math.clamp(SourceResourceType.INSTANCE.getInterfaceExportLimit(), 0, Integer.MAX_VALUE);
    }

    public int getMaxReceive() {
        return Math.clamp(SourceResourceType.INSTANCE.getInterfaceExportLimit(), 0, Integer.MAX_VALUE);
    }

    public boolean canAcceptSource(int source) {
        return this.receiveSource(source, true) > 0;
    }

    public boolean canProvideSource(int source) {
        return this.extractSource(source, true) > 0;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canExtract() {
        return true;
    }
}

