/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.client.StorageCellModels;
import appeng.api.stacks.AEKeyType;
import appeng.core.definitions.ItemDefinition;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.PortableCellItem;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.client.MESourceJarBlockEntityRenderer;
import gripe._90.arseng.client.SourceRenderer;
import gripe._90.arseng.definition.ArsEngBlockEntities;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.item.SourceCellItem;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@Mod(value="arseng", dist={Dist.CLIENT})
public class ArsEngClient {
    public ArsEngClient(IEventBus modEventBus) {
        AEKeyRendering.register((AEKeyType)SourceKeyType.TYPE, SourceKey.class, (AEKeyRenderHandler)SourceRenderer.INSTANCE);
        modEventBus.addListener(ArsEngClient::initItemColours);
        modEventBus.addListener(ArsEngClient::initCellModels);
        modEventBus.addListener(ArsEngClient::initBlockEntityRenderer);
    }

    private static void initCellModels(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            String prefix = "block/drive/cells/";
            StorageCellModels.registerModel(ArsEngItems.SOURCE_CELL_1K, (ResourceLocation)ArsEnergistique.makeId(prefix + "1k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.PORTABLE_SOURCE_CELL1K, (ResourceLocation)ArsEnergistique.makeId(prefix + "1k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.SOURCE_CELL_4K, (ResourceLocation)ArsEnergistique.makeId(prefix + "4k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.PORTABLE_SOURCE_CELL4K, (ResourceLocation)ArsEnergistique.makeId(prefix + "4k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.SOURCE_CELL_16K, (ResourceLocation)ArsEnergistique.makeId(prefix + "16k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.PORTABLE_SOURCE_CELL16K, (ResourceLocation)ArsEnergistique.makeId(prefix + "16k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.SOURCE_CELL_64K, (ResourceLocation)ArsEnergistique.makeId(prefix + "64k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.PORTABLE_SOURCE_CELL64K, (ResourceLocation)ArsEnergistique.makeId(prefix + "64k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.SOURCE_CELL_256K, (ResourceLocation)ArsEnergistique.makeId(prefix + "256k_source_cell"));
            StorageCellModels.registerModel(ArsEngItems.PORTABLE_SOURCE_CELL256K, (ResourceLocation)ArsEnergistique.makeId(prefix + "256k_source_cell"));
        });
    }

    private static void initBlockEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ArsEngBlockEntities.ME_SOURCE_JAR.get(), MESourceJarBlockEntityRenderer::new);
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        for (ItemDefinition<SourceCellItem> itemDefinition : ArsEngItems.getCells()) {
            event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)BasicStorageCell.getColor((ItemStack)stack, (int)tintIndex)), new ItemLike[]{itemDefinition});
        }
        for (ItemDefinition itemDefinition : ArsEngItems.getPortables()) {
            event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)PortableCellItem.getColor((ItemStack)stack, (int)tintIndex)), new ItemLike[]{itemDefinition});
        }
    }
}

