/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.block.create;

import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DyenamicsSailBlock
extends SailBlock {
    private final DyenamicDyeColor color;

    public DyenamicsSailBlock(BlockBehaviour.Properties properties, DyenamicDyeColor color) {
        super(properties, false, color.getAnalogue());
        this.color = color;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.frame) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DyenamicDyeColor color = DyenamicDyeColor.getColor((ItemStack)stack);
        if (color != null && color.getId() > 15) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - level.random.nextFloat() * 0.2f);
            }
            DyenamicsSailBlock.applyDye(state, level, pos, hitResult.getLocation(), color);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static void applyDye(BlockState state, Level level, BlockPos pos, Vec3 hit, DyenamicDyeColor color) {
        BlockState newState = ((Block)CreateCompat.SAILS.get(color).get()).defaultBlockState();
        if (state != (newState = BlockHelper.copyProperties((BlockState)state, (BlockState)newState))) {
            level.setBlockAndUpdate(pos, newState);
            return;
        }
        List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)hit, (Direction.Axis)((Direction)state.getValue((Property)FACING)).getAxis());
        for (Direction d : directions) {
            BlockPos offset = pos.relative(d);
            BlockState adjacentState = level.getBlockState(offset);
            Block block = adjacentState.getBlock();
            if (!(block instanceof SailBlock) || ((SailBlock)block).isFrame() || state.getValue((Property)FACING) != adjacentState.getValue((Property)FACING) || state == adjacentState) continue;
            level.setBlockAndUpdate(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.removeFirst();
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis() || visited.contains(offset = currentPos.relative(d)) || !((block = (adjacentState = level.getBlockState(offset)).getBlock()) instanceof SailBlock) || ((SailBlock)block).isFrame() && color != null || adjacentState.getValue((Property)FACING) != state.getValue((Property)FACING)) continue;
                if (state != adjacentState) {
                    level.setBlockAndUpdate(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }
}

