/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import cy.jdkdigital.productivemetalworks.common.block.FireBricksBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryCapacitorBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryControllerBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryDrainBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryTankBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryWindowBlock;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ProductiveMetalworksCompat {
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FOUNDRY_CONTROLLERS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FOUNDRY_DRAINS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FOUNDRY_TANKS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FOUNDRY_CAPACITORS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FOUNDRY_WINDOWS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FIRE_BRICKS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "productivemetalworks_" + color.getSerializedName();
        FOUNDRY_CONTROLLERS.put(color, DyenamicRegistry.registerBlock(prefix + "_foundry_controller", () -> new FoundryControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? 8 : 0).sound(SoundType.NETHER_BRICKS)), true));
        FOUNDRY_DRAINS.put(color, DyenamicRegistry.registerBlock(prefix + "_foundry_drain", () -> new FoundryDrainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).sound(SoundType.NETHER_BRICKS)), true));
        FOUNDRY_TANKS.put(color, DyenamicRegistry.registerBlock(prefix + "_foundry_tank", () -> new FoundryTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().sound(SoundType.NETHER_BRICKS)), true));
        FOUNDRY_CAPACITORS.put(color, DyenamicRegistry.registerBlock(prefix + "_foundry_capacitor", () -> new FoundryCapacitorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().sound(SoundType.NETHER_BRICKS)), true));
        FOUNDRY_WINDOWS.put(color, DyenamicRegistry.registerBlock(prefix + "_foundry_window", () -> new FoundryWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)), true));
        FIRE_BRICKS.put(color, DyenamicRegistry.registerBlock(prefix + "_fire_bricks", () -> new FireBricksBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).sound(SoundType.NETHER_BRICKS)), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(MetalworksRegistrator.TAB_KEY)) {
            FOUNDRY_CONTROLLERS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            FOUNDRY_DRAINS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            FOUNDRY_TANKS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            FOUNDRY_CAPACITORS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            FOUNDRY_WINDOWS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            FIRE_BRICKS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
        }
    }

    public static void addBlocks(BlockEntityTypeAddBlocksEvent event) {
        event.modify((BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get(), FOUNDRY_CONTROLLERS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)MetalworksRegistrator.FOUNDRY_DRAIN_BLOCK_ENTITY.get(), FOUNDRY_DRAINS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)MetalworksRegistrator.FOUNDRY_TANK_BLOCK_ENTITY.get(), FOUNDRY_TANKS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)MetalworksRegistrator.FOUNDRY_CAPACITOR_BLOCK_ENTITY.get(), FOUNDRY_CAPACITORS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
    }
}

