/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record OptionalLootItemBlockStatePropertyCondition(Holder<Block> block, Optional<StatePropertiesPredicate> properties) implements LootItemCondition
{
    public static final MapCodec<OptionalLootItemBlockStatePropertyCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").orElse((Object)((Holder)BuiltInRegistries.BLOCK.getHolder(BuiltInRegistries.BLOCK.getDefaultKey()).get())).forGetter(OptionalLootItemBlockStatePropertyCondition::block), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("properties").forGetter(OptionalLootItemBlockStatePropertyCondition::properties)).apply((Applicative)inst, OptionalLootItemBlockStatePropertyCondition::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)DyenamicsAndFriends.OPTIONAL_BLOCK_STATE_PROPERTY.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.BLOCK_STATE);
    }

    public boolean test(LootContext context) {
        BlockState blockstate = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        return blockstate != null && blockstate.is(this.block) && (this.properties.isEmpty() || this.properties.get().matches(blockstate));
    }

    public static Builder hasBlockStateProperties(Block pBlock) {
        return new Builder(pBlock);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Holder<Block> block;
        private Optional<StatePropertiesPredicate> properties = Optional.empty();

        public Builder(Block block) {
            this.block = block.builtInRegistryHolder();
        }

        public Builder setProperties(StatePropertiesPredicate.Builder statePredicateBuilder) {
            this.properties = statePredicateBuilder.build();
            return this;
        }

        public LootItemCondition build() {
            return new OptionalLootItemBlockStatePropertyCondition(this.block, this.properties);
        }
    }
}

