/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.net;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.gui.DeepLearnerContainer;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenDeepLearnerPayload() implements CustomPacketPayload
{
    public static final OpenDeepLearnerPayload INSTANCE = new OpenDeepLearnerPayload();
    public static final CustomPacketPayload.Type<OpenDeepLearnerPayload> TYPE = new CustomPacketPayload.Type(HostileNetworks.loc("open_deep_learner"));
    public static final StreamCodec<ByteBuf, OpenDeepLearnerPayload> CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Provider
    implements PayloadProvider<OpenDeepLearnerPayload> {
        public CustomPacketPayload.Type<OpenDeepLearnerPayload> getType() {
            return TYPE;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, OpenDeepLearnerPayload> getCodec() {
            return CODEC;
        }

        public void handle(OpenDeepLearnerPayload msg, IPayloadContext ctx) {
            ItemStack stack;
            Player player = ctx.player();
            if (ModList.get().isLoaded("curios") && player.containerMenu == player.inventoryMenu && (stack = CuriosCompat.getDeepLearner(player)).is(Hostile.Items.DEEP_LEARNER)) {
                DeepLearnerContainer.DeepLearnerSource src = DeepLearnerContainer.DeepLearnerSource.CURIOS;
                player.openMenu((MenuProvider)new DeepLearnerItem.Provider(src), buf -> buf.writeByte(src.ordinal()));
            }
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.SERVERBOUND);
        }

        public String getVersion() {
            return "1";
        }
    }
}

