/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.client;

import com.buuz135.transfer_labels.LabelInteractEvents;
import com.buuz135.transfer_labels.TransferLabels;
import com.buuz135.transfer_labels.client.RayTraceUtils;
import com.buuz135.transfer_labels.item.TransferLabelItem;
import com.buuz135.transfer_labels.storage.LabelBlock;
import com.buuz135.transfer_labels.storage.client.LabelClientStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class LabelClientEvents {
    public static List<LabelInteractEvents.DelayedEvent> CLIENT_UPDATE = new ArrayList<LabelInteractEvents.DelayedEvent>();

    @SubscribeEvent
    public void blockOverlayEvent(RenderHighlightEvent.Block event) {
        List<LabelBlock> nearbyLabels;
        Pair<LabelBlock, Direction> pair;
        boolean isHoldingLabel;
        double distance = Minecraft.getInstance().player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        boolean isHoldingAccessor = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)TransferLabels.LABEL_ACCESSOR.get());
        boolean bl = isHoldingLabel = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof TransferLabelItem || isHoldingAccessor;
        if (isHoldingLabel && (pair = RayTraceUtils.rayTraceVoxelShape(nearbyLabels = LabelClientStorage.getNearbyLabels(Minecraft.getInstance().level, event.getTarget().getBlockPos(), (int)(distance * distance)), (Level)Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, 0.0f, isHoldingAccessor ? null : event.getTarget().getBlockPos())) != null) {
            event.setCanceled(true);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            Vec3 cameraPos = event.getCamera().getPosition();
            double renderX = x - cameraPos.x;
            double renderY = y - cameraPos.y;
            double renderZ = z - cameraPos.z;
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(renderX, renderY, renderZ);
            LevelRenderer.renderLineBox((PoseStack)event.getPoseStack(), (VertexConsumer)Minecraft.getInstance().renderBuffers().outlineBufferSource().getBuffer(RenderType.lines()), (AABB)((LabelBlock)pair.getFirst()).collectShapes((Direction)pair.getSecond()), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            poseStack.popPose();
        }
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/dirt.png"), false, false)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {}, () -> {})).createCompositeState(true);
        return RenderType.create((String)"mycelial_render", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)262144, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    @SubscribeEvent
    public void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        BlockPos currentPos = Minecraft.getInstance().player.blockPosition();
        boolean isHoldingAccessor = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)TransferLabels.LABEL_ACCESSOR.get());
        boolean isHoldingLabel = Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof TransferLabelItem || isHoldingAccessor;
        int transparentAlpha = 100;
        List<LabelBlock> nearbyLabels = LabelClientStorage.getNearbyLabels(Minecraft.getInstance().level, currentPos, 400);
        PoseStack poseStack = event.getPoseStack();
        int combinedLight = 0xF000F0;
        int combinedOverlay = OverlayTexture.NO_OVERLAY;
        if (isHoldingLabel && Minecraft.getInstance().player.isCrouching() || isHoldingAccessor) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        for (LabelBlock label : nearbyLabels) {
            MeshData mesh;
            BufferBuilder buffer;
            Tesselator tesselator;
            double x = label.getPos().getX();
            double y = label.getPos().getY();
            double z = label.getPos().getZ();
            Vec3 cameraPos = event.getCamera().getPosition();
            double renderX = x - cameraPos.x;
            double renderY = y - cameraPos.y;
            double renderZ = z - cameraPos.z;
            poseStack.pushPose();
            poseStack.translate(renderX, renderY, renderZ);
            RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
            RenderSystem.enableBlend();
            float size = 1.0f;
            if (label.getLabels().containsKey(Direction.NORTH)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.NORTH).getLabel()));
                buffer.addVertex(poseStack.last().pose(), 0.0f, 0.0f, -0.001f).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 0.0f, size, -0.001f).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, size, -0.001f).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, 0.0f, -0.001f).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            if (label.getLabels().containsKey(Direction.SOUTH)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.SOUTH).getLabel()));
                buffer.addVertex(poseStack.last().pose(), size, 0.0f, 1.001f).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, size, 1.001f).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 0.0f, size, 1.001f).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 0.0f, 0.0f, 1.001f).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            if (label.getLabels().containsKey(Direction.WEST)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.WEST).getLabel()));
                buffer.addVertex(poseStack.last().pose(), -0.001f, 0.0f, size).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), -0.001f, size, size).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), -0.001f, size, 0.0f).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), -0.001f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            if (label.getLabels().containsKey(Direction.EAST)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.EAST).getLabel()));
                buffer.addVertex(poseStack.last().pose(), 1.001f, 0.0f, 0.0f).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 1.001f, size, 0.0f).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 1.001f, size, size).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 1.001f, 0.0f, size).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            if (label.getLabels().containsKey(Direction.UP)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.UP).getLabel()));
                buffer.addVertex(poseStack.last().pose(), 0.0f, 1.001f, 0.0f).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 0.0f, 1.001f, size).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, 1.001f, size).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, 1.001f, 0.0f).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            if (label.getLabels().containsKey(Direction.DOWN)) {
                tesselator = Tesselator.getInstance();
                buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LabelClientEvents.getTexture(label.getLabels().get(Direction.DOWN).getLabel()));
                buffer.addVertex(poseStack.last().pose(), 0.0f, -0.001f, size).setUv(0.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), 0.0f, -0.001f, 0.0f).setUv(0.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, -0.001f, 0.0f).setUv(1.0f, 1.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                buffer.addVertex(poseStack.last().pose(), size, -0.001f, size).setUv(1.0f, 0.0f).setLight(0xF000F0).setColor(255, 255, 255, isHoldingLabel ? 255 : transparentAlpha);
                mesh = buffer.build();
                if (mesh != null) {
                    BufferUploader.drawWithShader((MeshData)mesh);
                }
                tesselator.clear();
            }
            poseStack.popPose();
        }
        RenderSystem.enableDepthTest();
    }

    public static ResourceLocation getTexture(ItemStack stack) {
        if (stack.getItem() instanceof TransferLabelItem) {
            return ((TransferLabelItem)stack.getItem()).getTexture();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"transfer_labels", (String)"textures/item/itemstack_insert_transfer_label.png");
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post event) {
        int delay = 2;
        Level level = event.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            CLIENT_UPDATE.forEach(leftClickBlock -> {
                if (clientLevel.getGameTime() > leftClickBlock.time() + (long)delay && leftClickBlock.event().getLevel().equals(event.getLevel())) {
                    leftClickBlock.event().getLevel().destroyBlockProgress(leftClickBlock.event().getEntity().getId(), leftClickBlock.event().getPos(), -1);
                }
            });
            CLIENT_UPDATE.removeIf(leftClickBlock -> clientLevel.getGameTime() > leftClickBlock.time() + (long)delay && leftClickBlock.event().getLevel().equals(event.getLevel()));
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        boolean validInteraction = event.getItemStack().getItem() instanceof TransferLabelItem || event.getItemStack().is(TransferLabels.LABEL_ACCESSOR);
        Level level = event.getLevel();
        if (level instanceof ClientLevel) {
            List<LabelBlock> nearbyLabels;
            Pair<LabelBlock, Direction> pair;
            ClientLevel clientLevel = (ClientLevel)level;
            if (validInteraction && (pair = RayTraceUtils.rayTraceVoxelShape(nearbyLabels = LabelClientStorage.getNearbyLabels(clientLevel, event.getPos(), 20), (Level)clientLevel, (LivingEntity)event.getEntity(), 0.0f, event.getItemStack().is(TransferLabels.LABEL_ACCESSOR) ? null : event.getPos())) != null) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level;
        if (event.getItemStack().getItem() instanceof TransferLabelItem && event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && (level = event.getLevel()) instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            double distance = event.getEntity().getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
            List<LabelBlock> nearbyLabels = LabelClientStorage.getNearbyLabels(clientLevel, event.getPos(), (int)(distance * distance));
            Pair<LabelBlock, Direction> pair = RayTraceUtils.rayTraceVoxelShape(nearbyLabels, (Level)clientLevel, (LivingEntity)event.getEntity(), 0.0f, event.getPos());
            if (pair != null) {
                event.setCanceled(true);
                CLIENT_UPDATE.add(new LabelInteractEvents.DelayedEvent(event, clientLevel.getGameTime()));
            }
        }
    }
}

