/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.filter.extras;

import com.hrznstudio.titanium.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTagFilterExtra
implements INBTSerializable<CompoundTag> {
    private final int amount;
    private List<TagKey<Fluid>> extra;

    public FluidTagFilterExtra(int amount) {
        this.amount = amount;
        this.extra = new ArrayList<TagKey<Fluid>>();
        for (int i = 0; i < amount; ++i) {
            this.extra.add(null);
        }
    }

    public void initTag(int slot, FluidStack item) {
        List tags = item.getTags().toList();
        if (tags.isEmpty()) {
            this.extra.set(slot, null);
        } else {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(0)));
        }
    }

    public void nextTag(int slot, FluidStack item) {
        List tags = item.getTags().toList();
        if (tags.isEmpty()) {
            this.extra.set(slot, null);
            return;
        }
        TagKey<Fluid> currentTag = this.extra.get(slot);
        if (currentTag == null) {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(0)));
            return;
        }
        int currentIndex = -1;
        for (int i = 0; i < tags.size(); ++i) {
            if (!((TagKey)tags.get(i)).location().equals((Object)currentTag.location())) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1 || currentIndex == tags.size() - 1) {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(0)));
        } else {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(currentIndex + 1)));
        }
    }

    public void previousTag(int slot, FluidStack item) {
        List tags = item.getTags().toList();
        if (tags.isEmpty()) {
            this.extra.set(slot, null);
            return;
        }
        TagKey<Fluid> currentTag = this.extra.get(slot);
        if (currentTag == null) {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(tags.size() - 1)));
            return;
        }
        int currentIndex = -1;
        for (int i = 0; i < tags.size(); ++i) {
            if (!((TagKey)tags.get(i)).location().equals((Object)currentTag.location())) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1 || currentIndex == 0) {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(tags.size() - 1)));
        } else {
            this.extra.set(slot, (TagKey<Fluid>)((TagKey)tags.get(currentIndex - 1)));
        }
    }

    public List<TagKey<Fluid>> getExtra() {
        return this.extra;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.extra.size(); ++i) {
            if (this.extra.get(i) == null) continue;
            compoundTag.putString("" + i, this.extra.get(i).location().toString());
        }
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        for (int i = 0; i < this.extra.size(); ++i) {
            if (compoundTag.contains("" + i)) {
                this.extra.set(i, (TagKey<Fluid>)TagUtil.getFluidTag((ResourceLocation)ResourceLocation.parse((String)compoundTag.getString("" + i))));
                continue;
            }
            this.extra.set(i, null);
        }
    }
}

