/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.storage;

import com.buuz135.transfer_labels.storage.LabelBlock;
import com.buuz135.transfer_labels.storage.LabelStorage;
import com.buuz135.transfer_labels.storage.client.LabelClientStorage;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.LocatorType;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;

public class LabelLocatorInstance
extends LocatorInstance {
    public static final LocatorType LABEL = new LocatorType("transfer_label", LabelLocatorInstance::new);
    private BlockPos pos;
    private Direction direction;

    public LabelLocatorInstance(BlockPos pos, Direction direction) {
        super(LABEL);
        this.pos = pos;
        this.direction = direction;
    }

    public LabelLocatorInstance() {
        super(LABEL);
    }

    public Optional<?> locale(Player player) {
        ClientLevel clientLevel;
        HashMap<BlockPos, LabelBlock> storage;
        Level level = player.getCommandSenderWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HashMap<BlockPos, LabelBlock> storage2 = LabelStorage.getStorageFor(serverLevel).getLabelBlocksMap();
            if (storage2.containsKey(this.pos) && storage2.get(this.pos).getLabels().containsKey(this.direction)) {
                return Optional.of(storage2.get(this.pos).getLabels().get(this.direction));
            }
        } else if (level instanceof ClientLevel && (storage = LabelClientStorage.getStorage(clientLevel = (ClientLevel)level).getLabelBlocksMap()).containsKey(this.pos) && storage.get(this.pos).getLabels().containsKey(this.direction)) {
            return Optional.of(storage.get(this.pos).getLabels().get(this.direction));
        }
        return Optional.empty();
    }

    public ContainerLevelAccess getWorldPosCallable(Level world) {
        return ContainerLevelAccess.create((Level)world, (BlockPos)this.pos);
    }
}

