/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.autocrafting.advancedautocrafter;

import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.autocrafting.advancedautocrafter.AdvancedAutocrafterBlockEntity;
import edivad.extrastorage.autocrafting.advancedautocrafter.CrafterTier;
import edivad.extrastorage.setup.ESBlockEntities;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AdvancedAutocrafterBlock
extends AbstractDirectionalBlock<Direction>
implements BlockItemProvider<BaseBlockItem>,
EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final Component HELP = IdentifierUtil.createTranslation((String)"item", (String)"autocrafter.help");
    private final AbstractBlockEntityTicker<AdvancedAutocrafterBlockEntity> ticker;
    private final CrafterTier tier;

    public AdvancedAutocrafterBlock(CrafterTier tier) {
        super(BlockConstants.PROPERTIES);
        this.tier = tier;
        this.ticker = new NetworkNodeBlockEntityTicker((Supplier)ESBlockEntities.CRAFTER.get((Object)this.tier), ACTIVE);
    }

    protected DirectionType<Direction> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancedAutocrafterBlockEntity(this.tier, pos, state);
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return this.ticker.get(level, type);
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, HELP);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.extrastorage.slotCrafting", (Object[])new Object[]{this.tier.getSlots()}).withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.extrastorage.baseSpeed", (Object[])new Object[]{this.tier.getCraftingSpeed()}).withStyle(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.extrastorage.holdShift").withStyle(ChatFormatting.GRAY));
        }
    }
}

