/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.instrumentation.NearestSectionFilter;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.function.Predicate;

abstract class BreakpointLocation {
    protected final SourceElement[] sourceElements;
    static final BreakpointLocation ANY = new BreakpointSourceLocation();
    static final URI ANY_SOURCE = URI.create("");

    protected BreakpointLocation(SourceElement[] sourceElements) {
        this.sourceElements = sourceElements;
    }

    static BreakpointLocation create(Object key, SourceElement[] sourceElements, SourceSection sourceSection) {
        return new BreakpointSourceLocation(key, sourceElements, sourceSection);
    }

    static BreakpointLocation create(Object key, SourceElement[] sourceElements, int line, int column) {
        return new BreakpointSourceLocation(key, sourceElements, line, column);
    }

    static BreakpointLocation create(SourceElement[] sourceElements, SuspensionFilter filter) {
        return new BreakpointFilteredLocation(sourceElements, filter);
    }

    final boolean containsRoot() {
        if (this.sourceElements == null) {
            return true;
        }
        for (SourceElement elem : this.sourceElements) {
            if (SourceElement.ROOT != elem) continue;
            return true;
        }
        return false;
    }

    abstract boolean isLoadBindingNeeded();

    abstract LocationFilters createLocationFilters(SuspendAnchor var1);

    abstract SourceSectionFilter createExecLocationFilter(SourceSection var1, SuspendAnchor var2);

    private static Class<?>[] getTags(SourceElement[] sourceElements) {
        Class[] elementTags = new Class[sourceElements.length];
        for (int i2 = 0; i2 < elementTags.length; ++i2) {
            elementTags[i2] = sourceElements[i2].getTag();
        }
        return elementTags;
    }

    private static void setTags(SourceSectionFilter.Builder f2, SourceElement[] sourceElements) {
        f2.tagIs(BreakpointLocation.getTags(sourceElements));
    }

    private static void setTags(NearestSectionFilter.Builder f2, SourceElement[] sourceElements) {
        f2.tagIs(BreakpointLocation.getTags(sourceElements));
    }

    private static final class BreakpointSourceLocation
    extends BreakpointLocation {
        private final Object key;
        private final SourceSection sourceSection;
        private final int line;
        private final int column;

        BreakpointSourceLocation(Object key, SourceElement[] sourceElements, SourceSection sourceSection) {
            super(sourceElements);
            assert (key instanceof Source || key instanceof URI);
            this.key = key;
            this.sourceSection = sourceSection;
            this.line = -1;
            this.column = -1;
        }

        BreakpointSourceLocation(Object key, SourceElement[] sourceElements, int line, int column) {
            super(sourceElements);
            assert (key instanceof Source || key instanceof URI);
            assert (line > 0 || line == -1);
            assert (column > 0 || column == -1);
            this.key = key;
            this.line = line;
            this.column = column;
            this.sourceSection = null;
        }

        private BreakpointSourceLocation() {
            super(null);
            this.key = null;
            this.line = -1;
            this.column = -1;
            this.sourceSection = null;
        }

        private SourceFilter createSourceFilter() {
            if (this.key == null) {
                return null;
            }
            SourceFilter.Builder f2 = SourceFilter.newBuilder();
            if (this.key instanceof URI) {
                f2.sourceIs(this.createSourcePredicate());
            } else {
                assert (this.key instanceof Source);
                Source s2 = (Source)this.key;
                f2.sourceIs(s2);
            }
            return f2.build();
        }

        private Predicate<Source> createSourcePredicate() {
            if (this.key == null) {
                return null;
            }
            if (this.key instanceof URI) {
                if (this.key == ANY_SOURCE) {
                    return new Predicate<Source>(){

                        @Override
                        public boolean test(Source s2) {
                            return true;
                        }
                    };
                }
                final URI sourceUri = (URI)this.key;
                final String sourceRawPath = sourceUri.getRawPath() != null ? sourceUri.getRawPath() : sourceUri.getRawSchemeSpecificPart();
                return new Predicate<Source>(this){
                    final /* synthetic */ BreakpointSourceLocation this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean test(Source s2) {
                        URI uri = s2.getURI();
                        if (uri.isAbsolute()) {
                            return sourceUri.equals(uri);
                        }
                        return sourceRawPath != null && sourceRawPath.endsWith(uri.getRawPath());
                    }

                    public String toString() {
                        return "URI equals " + String.valueOf(sourceUri);
                    }
                };
            }
            assert (this.key instanceof Source);
            final Source source = (Source)this.key;
            return new Predicate<Source>(this){
                final /* synthetic */ BreakpointSourceLocation this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean test(Source s2) {
                    return source.equals(s2);
                }
            };
        }

        @Override
        boolean isLoadBindingNeeded() {
            return this.line != -1;
        }

        @Override
        LocationFilters createLocationFilters(SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f2 = SourceSectionFilter.newBuilder();
            NearestSectionFilter nearestFilter = null;
            if (this.key == null) {
                f2.tagIs(DebuggerTags.AlwaysHalt.class);
            } else {
                if (this.key != ANY_SOURCE) {
                    f2.sourceFilter(this.createSourceFilter());
                }
                if (this.line != -1) {
                    assert (this.sourceSection == null);
                    NearestSectionFilter.Builder nearestBuilder = NearestSectionFilter.newBuilder(this.line, this.column);
                    nearestBuilder.anchorStart(SuspendAnchor.BEFORE == suspendAnchor);
                    BreakpointLocation.setTags(nearestBuilder, this.sourceElements);
                    nearestFilter = nearestBuilder.build();
                } else {
                    if (this.sourceSection != null) {
                        f2.sourceSectionEquals(this.sourceSection);
                    }
                    BreakpointLocation.setTags(f2, this.sourceElements);
                }
            }
            return new LocationFilters(f2.build(), nearestFilter);
        }

        @Override
        SourceSectionFilter createExecLocationFilter(SourceSection location, SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f2 = SourceSectionFilter.newBuilder();
            if (this.key == null) {
                return f2.tagIs(DebuggerTags.AlwaysHalt.class).build();
            }
            if (this.column > 0) {
                f2.sourceSectionEquals(location);
            } else {
                switch (suspendAnchor) {
                    case BEFORE: {
                        f2.lineStartsIn(SourceSectionFilter.IndexRange.byLength(location.getStartLine(), 1));
                        break;
                    }
                    case AFTER: {
                        f2.lineEndsIn(SourceSectionFilter.IndexRange.byLength(location.getEndLine(), 1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(suspendAnchor.name());
                    }
                }
                f2.sourceIs(location.getSource());
            }
            BreakpointLocation.setTags(f2, this.sourceElements);
            return f2.build();
        }

        public String toString() {
            Object keyDescription = this.key == null ? "AlwaysHalt" : (this.key instanceof Source ? "sourceName=" + ((Source)this.key).getName() : (this.key instanceof URI ? "uri=" + ((URI)this.key).toString() : this.key.toString()));
            return (String)keyDescription + ", line=" + this.line + ", column=" + this.column;
        }
    }

    private static final class BreakpointFilteredLocation
    extends BreakpointLocation {
        private final SuspensionFilter filter;

        BreakpointFilteredLocation(SourceElement[] sourceElements, SuspensionFilter filter) {
            super(sourceElements);
            this.filter = filter;
        }

        @Override
        boolean isLoadBindingNeeded() {
            return false;
        }

        @Override
        LocationFilters createLocationFilters(SuspendAnchor suspendAnchor) {
            SourceSectionFilter.Builder f2 = SourceSectionFilter.newBuilder();
            SourceFilter.Builder sourceFilterBuilder = SourceFilter.newBuilder();
            if (this.filter != null) {
                Predicate<Source> sourcePredicate = this.filter.getSourcePredicate();
                if (sourcePredicate != null) {
                    sourceFilterBuilder.sourceIs(sourcePredicate);
                }
                sourceFilterBuilder.includeInternal(this.filter.isInternalIncluded());
            }
            SourceFilter sourceFilter = sourceFilterBuilder.build();
            f2.sourceFilter(sourceFilter);
            BreakpointLocation.setTags(f2, this.sourceElements);
            return new LocationFilters(f2.build(), null);
        }

        @Override
        SourceSectionFilter createExecLocationFilter(SourceSection location, SuspendAnchor suspendAnchor) {
            return null;
        }
    }

    static final class LocationFilters {
        final SourceSectionFilter sectionFilter;
        final NearestSectionFilter nearestFilter;

        private LocationFilters(SourceSectionFilter sectionFilter, NearestSectionFilter nearestFilter) {
            this.sectionFilter = sectionFilter;
            this.nearestFilter = nearestFilter;
        }
    }
}

