/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class JSCollectionsNormalizeNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSCollectionsNormalizeNode create() {
        return JSCollectionsNormalizeNodeGen.create();
    }

    @Specialization
    static int doInt(int value) {
        return value;
    }

    @Specialization
    static Object doDouble(double value) {
        return JSSet.normalizeDouble(value);
    }

    @Specialization
    static TruffleString doString(TruffleString value) {
        return value;
    }

    @Specialization
    static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization
    static Object doDynamicObject(JSDynamicObject object) {
        return object;
    }

    @Specialization
    static Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    static BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization
    static Object doLong(long value) {
        if (JSRuntime.longFitsInDouble(value)) {
            return JSCollectionsNormalizeNode.doDouble(value);
        }
        return BigInt.valueOf(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    final Object doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(value)) {
                return JSCollectionsNormalizeNode.doBoolean(interop.asBoolean(value));
            }
            if (interop.isString(value)) {
                return JSCollectionsNormalizeNode.doString(interop.asTruffleString(value));
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return JSCollectionsNormalizeNode.doInt(interop.asInt(value));
                }
                if (interop.fitsInDouble(value)) {
                    return JSCollectionsNormalizeNode.doDouble(interop.asDouble(value));
                }
                if (interop.fitsInLong(value)) {
                    return JSCollectionsNormalizeNode.doLong(interop.asLong(value));
                }
                if (interop.fitsInBigInteger(value)) {
                    return JSCollectionsNormalizeNode.doBigInt(BigInt.fromBigInteger(interop.asBigInteger(value)));
                }
                assert (value instanceof TruffleObject);
                return value;
            }
            return value;
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorUnboxException(value, e2, this);
        }
    }
}

