/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

public abstract class Log2Node
extends MathOperation {
    public Log2Node(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    private static double lowBits(double x2, int low) {
        long transX = Double.doubleToRawLongBits(x2);
        return Double.longBitsToDouble(transX & 0xFFFFFFFF00000000L | (long)low);
    }

    private static int highBits(double x2) {
        long transducer = Double.doubleToRawLongBits(x2);
        return (int)(transducer >> 32);
    }

    private static double highBits(double x2, int high) {
        long transX = Double.doubleToRawLongBits(x2);
        return Double.longBitsToDouble(transX & 0xFFFFFFFFL | (long)high << 32);
    }

    @CompilerDirectives.TruffleBoundary
    private static double log2Impl(double x2) {
        double ss;
        int k2;
        double xAbs = Math.abs(x2);
        int hx = Log2Node.highBits(x2);
        int ix = hx & Integer.MAX_VALUE;
        double cp = 0.9617966939259756;
        double cph = 0.9617967009544373;
        double cpl = -7.028461650952758E-9;
        int n2 = 0;
        if (ix < 0x100000) {
            n2 -= 53;
            ix = Log2Node.highBits(xAbs *= 9.007199254740992E15);
        }
        n2 += (ix >> 20) - 1023;
        int j2 = ix & 0xFFFFF;
        ix = j2 | 0x3FF00000;
        if (j2 <= 235662) {
            k2 = 0;
        } else if (j2 < 767610) {
            k2 = 1;
        } else {
            k2 = 0;
            ++n2;
            ix -= 0x100000;
        }
        xAbs = Log2Node.highBits(xAbs, ix);
        double[] bp = new double[]{1.0, 1.5};
        double[] dph = new double[]{0.0, 0.5849624872207642};
        double[] dpl = new double[]{0.0, 1.350039202129749E-8};
        double l1 = 0.5999999999999946;
        double l2 = 0.4285714285785502;
        double l3 = 0.33333332981837743;
        double l4 = 0.272728123808534;
        double l5 = 0.23066074577556175;
        double l6 = 0.20697501780033842;
        double u2 = xAbs - bp[k2];
        double v2 = 1.0 / (xAbs + bp[k2]);
        double sh = ss = u2 * v2;
        sh = Log2Node.lowBits(sh, 0);
        double th = 0.0;
        th = Log2Node.highBits(th, (ix >> 1 | 0x20000000) + 524288 + (k2 << 18));
        double tl = xAbs - (th - bp[k2]);
        double sl = v2 * (u2 - sh * th - sh * tl);
        double s2 = ss * ss;
        double r2 = s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
        s2 = sh * sh;
        th = 3.0 + s2 + (r2 += sl * (sh + ss));
        th = Log2Node.lowBits(th, 0);
        tl = r2 - (th - 3.0 - s2);
        u2 = sh * th;
        v2 = sl * th + tl * ss;
        double ph = u2 + v2;
        ph = Log2Node.lowBits(ph, 0);
        double pl = v2 - (ph - u2);
        double zh = 0.9617967009544373 * ph;
        double zl = -7.028461650952758E-9 * ph + pl * 0.9617966939259756 + dpl[k2];
        double t2 = n2;
        double t1 = zh + zl + dph[k2] + t2;
        t1 = Log2Node.lowBits(t1, 0);
        double t22 = zl - (t1 - t2 - dph[k2] - zh);
        return t1 + t22;
    }

    @Specialization
    protected double log2(double x2) {
        if (x2 < 0.0 || Double.isNaN(x2)) {
            return Double.NaN;
        }
        if (x2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x2 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return Log2Node.log2Impl(x2);
    }

    @Specialization
    protected double log2(Object a2) {
        return this.log2(this.toDouble(a2));
    }
}

