/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionType;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

final class EnterpriseEngineOptions {
    static final OptionKey<String[]> SpawnIsolate = new OptionKey<String[]>(null, new OptionType<String[]>("<boolean|languages>", string -> {
        if (string.equals("true")) {
            return new String[0];
        }
        if (string.equals("false")) {
            return null;
        }
        if (string.isEmpty()) {
            return new String[0];
        }
        return string.split(",");
    }));
    static final OptionKey<String> IsolateLibrary = new OptionKey<String>(null, OptionType.defaultType(String.class));
    static final OptionKey<Long> HostCallStackHeadRoom = new OptionKey<Long>(131072L, EnterpriseEngineOptions.createSizeInBytesType("engine.HostCallStackHeadRoom", 1L));
    static final OptionKey<Long> InterpreterCallStackHeadRoom = new OptionKey<Long>(0L, EnterpriseEngineOptions.createSizeInBytesType("engine.InterpreterCallStackHeadRoom", 0L));
    public static final OptionKey<OptionMap<String>> IsolateOption = OptionKey.mapOf(String.class);
    static final OptionKey<Boolean> IsolateMemoryProtection = new OptionKey<Boolean>(false);
    static final OptionKey<UntrustedCodeMitigationPolicy> UntrustedCodeMitigation = new OptionKey<UntrustedCodeMitigationPolicy>(UntrustedCodeMitigationPolicy.NONE);
    static final OptionKey<Long> MaxIsolateMemory = new OptionKey<Long>(-1L, EnterpriseEngineOptions.createSizeInBytesType("engine.MaxIsolateMemory", 32L * SizeUnit.MEGABYTE.factor));

    EnterpriseEngineOptions() {
    }

    static boolean isIsolateMemoryProtection(OptionValues optionValues) {
        return IsolateMemoryProtection.getValue(optionValues) != false || UntrustedCodeMitigation.getValue(optionValues) == UntrustedCodeMitigationPolicy.HARDWARE;
    }

    private static OptionType<Long> createSizeInBytesType(final String string, final long l2) {
        return new OptionType<Long>("sizeinbytes", new Function<String, Long>(){

            @Override
            public Long apply(String string3) {
                try {
                    SizeUnit sizeUnit = null;
                    for (SizeUnit sizeUnit2 : SizeUnit.values()) {
                        if (!string3.endsWith(sizeUnit2.symbol)) continue;
                        sizeUnit = sizeUnit2;
                        break;
                    }
                    if (sizeUnit == null) {
                        throw this.invalidValue(string3);
                    }
                    String string2 = string3.substring(0, string3.length() - sizeUnit.symbol.length());
                    long l22 = Long.parseLong(string2);
                    if (l22 < 0L) {
                        throw this.invalidValue(string3);
                    }
                    if ((l22 = Math.multiplyExact(l22, sizeUnit.factor)) < l2) {
                        throw this.invalidRange(string3);
                    }
                    return l22;
                }
                catch (ArithmeticException | NumberFormatException runtimeException) {
                    throw this.invalidValue(string3);
                }
            }

            private IllegalArgumentException invalidValue(String string2) {
                throw new IllegalArgumentException("Invalid size of '" + string2 + "' specified for the '" + string + "' option. A valid size consists of a positive integer value and a byte-based size unit. For example '512KB' or '100MB'. Valid size units are 'B' for bytes, 'KB' for kilobytes, 'MB' for megabytes, and 'GB' for gigabytes ");
            }

            private IllegalArgumentException invalidRange(String string2) {
                throw new IllegalArgumentException("Invalid size of '" + string2 + "' specified for the '" + string + "' option. " + String.format("Valid size must be greater or equal to %s.", this.toUnitString(l2)));
            }

            private String toUnitString(long l22) {
                String string2 = "B";
                long l3 = l22;
                if (l22 > SizeUnit.GIGABYTE.factor && l22 % SizeUnit.GIGABYTE.factor == 0L) {
                    string2 = SizeUnit.GIGABYTE.symbol;
                    l3 /= SizeUnit.GIGABYTE.factor;
                } else if (l22 > SizeUnit.MEGABYTE.factor && l22 % SizeUnit.MEGABYTE.factor == 0L) {
                    string2 = SizeUnit.MEGABYTE.symbol;
                    l3 /= SizeUnit.MEGABYTE.factor;
                } else if (l22 > SizeUnit.KILOBYTE.factor && l22 % SizeUnit.KILOBYTE.factor == 0L) {
                    string2 = SizeUnit.KILOBYTE.symbol;
                    l3 /= SizeUnit.KILOBYTE.factor;
                }
                return l3 + string2;
            }
        });
    }

    static enum UntrustedCodeMitigationPolicy {
        NONE,
        HARDWARE,
        SOFTWARE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static enum SizeUnit {
        GIGABYTE("GB", 0x40000000L),
        MEGABYTE("MB", 0x100000L),
        KILOBYTE("KB", 1024L),
        BYTE("B", 1L);

        private final String symbol;
        private final long factor;

        private SizeUnit(String string2, long l2) {
            this.symbol = string2;
            this.factor = l2;
        }
    }
}

