/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSDirectoryStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSFileSystem;
import com.oracle.truffle.polyglot.enterprise.HSPath;
import com.oracle.truffle.polyglot.enterprise.HSPathGen;
import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannel;
import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannelGen;
import com.oracle.truffle.polyglot.enterprise.NativeDirectoryStreamFilterGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.HSObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.TypeLiteral;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.CurrentIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.FileSystem;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

final class HSFileSystemGen {
    HSFileSystemGen() {
    }

    static HSFileSystem createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSFileSystem {
        private static final BinaryMarshaller<Charset> charsetMarshaller;
        private static final BinaryMarshaller<CopyOption> copyOptionMarshaller;
        private static final BinaryMarshaller<FileAttribute<?>> fileAttributeOfObjectMarshaller;
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<Map<String, Object>> mapOfStringObjectWithFileAttributeMapMarshaller;
        private static final BinaryMarshaller<Object> objectWithFileAttributeValueMarshaller;
        private static final BinaryMarshaller<Set<? extends AccessMode>> setOfExtendsAccessModeMarshaller;
        private static final BinaryMarshaller<Set<? extends OpenOption>> setOfExtendsOpenOptionMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkAccess(Path path, Set<? extends AccessMode> set, LinkOption ... linkOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n3 = setOfExtendsAccessModeMarshaller.inferSize(set) + 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        setOfExtendsAccessModeMarshaller.write((BinaryOutput)object, set);
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object).writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object, linkOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.checkAccessMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (copyOptionArray != null && copyOptionArray.length > 0 ? copyOptionArray.length * copyOptionMarshaller.inferSize(copyOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (copyOptionArray != null) {
                            ((BinaryOutput)object).writeInt(copyOptionArray.length);
                            for (CopyOption copyOption : copyOptionArray) {
                                copyOptionMarshaller.write((BinaryOutput)object, copyOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(4, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(path2 != null ? ((HSObject)((Object)path2)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(3).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.copyMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (fileAttributeArray != null) {
                            ((BinaryOutput)object).writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)object, fileAttribute);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createDirectoryMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void createLink(Path path, Path path2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(3, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                jValue.addressOf(2).setJObject(path2 != null ? ((HSObject)((Object)path2)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createLinkMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (fileAttributeArray != null) {
                            ((BinaryOutput)object).writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)object, fileAttribute);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(4, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(path2 != null ? ((HSObject)((Object)path2)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(3).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createSymbolicLinkMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void delete(Path path) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.deleteMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Charset getEncoding(Path path) {
            Charset charset;
            block6: {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                JNI.JByteArray jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getEncodingMethod, jValue);
                int n2 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n2);
                try {
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n2, cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n2);
                    charset = charsetMarshaller.read(binaryInput);
                    if (cCharPointer2 == cCharPointer) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free(cCharPointer2);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer2);
            }
            return charset;
        }

        @Override
        public String getMimeType(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return JNIUtil.createString(jNIEnv, (JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getMimeTypeMethod, jValue));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public String getPathSeparator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return JNIUtil.createString(jNIEnv, (JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getPathSeparatorMethod, jValue));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public String getSeparator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return JNIUtil.createString(jNIEnv, (JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getSeparatorMethod, jValue));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path getTempDirectory() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getTempDirectoryMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSameFile(Path path, Path path2, LinkOption ... linkOptionArray) throws IOException {
            boolean bl;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object).writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object, linkOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(4, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(path2 != null ? ((HSObject)((Object)path2)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(3).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isSameFileMethod, (JNI.JValue)object);
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (copyOptionArray != null && copyOptionArray.length > 0 ? copyOptionArray.length * copyOptionMarshaller.inferSize(copyOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (copyOptionArray != null) {
                            ((BinaryOutput)object).writeInt(copyOptionArray.length);
                            for (CopyOption copyOption : copyOptionArray) {
                                copyOptionMarshaller.write((BinaryOutput)object, copyOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(4, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(path2 != null ? ((HSObject)((Object)path2)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(3).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.moveMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
            HSSeekableByteChannel hSSeekableByteChannel;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n3 = setOfExtendsOpenOptionMarshaller.inferSize(set) + 4 + (fileAttributeArray != null && fileAttributeArray.length > 0 ? fileAttributeArray.length * fileAttributeOfObjectMarshaller.inferSize(fileAttributeArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        setOfExtendsOpenOptionMarshaller.write((BinaryOutput)object, set);
                        if (fileAttributeArray != null) {
                            ((BinaryOutput)object).writeInt(fileAttributeArray.length);
                            for (FileAttribute<?> fileAttribute : fileAttributeArray) {
                                fileAttributeOfObjectMarshaller.write((BinaryOutput)object, fileAttribute);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.newByteChannelMethod, (JNI.JValue)object);
                    HSSeekableByteChannel hSSeekableByteChannel2 = hSSeekableByteChannel = r2.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSSeekableByteChannel;
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(CurrentIsolate.getIsolate().rawValue());
                jValue.addressOf(2).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                jValue.addressOf(3).setLong(NativeObjectHandles.create(filter));
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.newDirectoryStreamMethod, jValue);
                return r2.isNonNull() ? HSDirectoryStreamGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path parsePath(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.parsePathMethod2, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Path parsePath(URI uRI) {
            HSPath hSPath;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = uRIMarshaller.inferSize(uRI);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        uRIMarshaller.write((BinaryOutput)object, uRI);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.parsePathMethod3, (JNI.JValue)object);
                    HSPath hSPath2 = hSPath = r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
            Map<String, Object> map;
            block20: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object2).writeInt(linkOptionArray.length);
                            for (LinkOption object3 : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object2, object3);
                            }
                        } else {
                            ((BinaryOutput)object2).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(4, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.getHandle());
                    object2.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object2.addressOf(2).setJObject(JNIUtil.createHSString(jNIEnv, string));
                    object2.addressOf(3).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readAttributesMethod, (JNI.JValue)object2);
                    int n5 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n5);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n5, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n5);
                    map = mapOfStringObjectWithFileAttributeMapMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return map;
        }

        @Override
        public Path readSymbolicLink(Path path) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readSymbolicLinkMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n3 = objectWithFileAttributeValueMarshaller.inferSize(object) + 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object2 = BinaryOutput.create(cCharPointer, n2, false);){
                        objectWithFileAttributeValueMarshaller.write((BinaryOutput)object2, object);
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object2).writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object2, linkOption);
                            }
                        } else {
                            ((BinaryOutput)object2).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object2).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object2).getAddress());
                    }
                    object2 = StackValue.get(4, JNI.JValue.class);
                    object2.addressOf(0).setJObject(this.getHandle());
                    object2.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object2.addressOf(2).setJObject(JNIUtil.createHSString(jNIEnv, string));
                    object2.addressOf(3).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.setAttributeMethod, (JNI.JValue)object2);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void setCurrentWorkingDirectory(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.setCurrentWorkingDirectoryMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path toAbsolutePath(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toAbsolutePathMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Path toRealPath(Path path, LinkOption ... linkOptionArray) throws IOException {
            HSPath hSPath;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object).writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object, linkOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                    object.addressOf(2).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toRealPathMethod, (JNI.JValue)object);
                    HSPath hSPath2 = hSPath = r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSPath;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            charsetMarshaller = jNIConfig.lookupMarshaller(Charset.class, new Class[0]);
            copyOptionMarshaller = jNIConfig.lookupMarshaller(CopyOption.class, new Class[0]);
            fileAttributeOfObjectMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<FileAttribute<?>>(){}, new Class[0]);
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            mapOfStringObjectWithFileAttributeMapMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Map<String, Object>>(){}, PolyglotJNIConfig.FileAttributeMap.class);
            objectWithFileAttributeValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.FileAttributeValue.class);
            setOfExtendsAccessModeMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<? extends AccessMode>>(){}, new Class[0]);
            setOfExtendsOpenOptionMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<? extends OpenOption>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod checkAccessMethod;
            final JNICalls.JNIMethod copyMethod;
            final JNICalls.JNIMethod createDirectoryMethod;
            final JNICalls.JNIMethod createLinkMethod;
            final JNICalls.JNIMethod createSymbolicLinkMethod;
            final JNICalls.JNIMethod deleteMethod;
            final JNICalls.JNIMethod getEncodingMethod;
            final JNICalls.JNIMethod getMimeTypeMethod;
            final JNICalls.JNIMethod getPathSeparatorMethod;
            final JNICalls.JNIMethod getSeparatorMethod;
            final JNICalls.JNIMethod getTempDirectoryMethod;
            final JNICalls.JNIMethod isSameFileMethod;
            final JNICalls.JNIMethod moveMethod;
            final JNICalls.JNIMethod newByteChannelMethod;
            final JNICalls.JNIMethod newDirectoryStreamMethod;
            final JNICalls.JNIMethod parsePathMethod2;
            final JNICalls.JNIMethod parsePathMethod3;
            final JNICalls.JNIMethod readAttributesMethod;
            final JNICalls.JNIMethod readSymbolicLinkMethod;
            final JNICalls.JNIMethod setAttributeMethod;
            final JNICalls.JNIMethod setCurrentWorkingDirectoryMethod;
            final JNICalls.JNIMethod toAbsolutePathMethod;
            final JNICalls.JNIMethod toRealPathMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.checkAccessMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "checkAccess", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)V");
                this.copyMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "copy", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.createDirectoryMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "createDirectory", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)V");
                this.createLinkMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "createLink", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;)V");
                this.createSymbolicLinkMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "createSymbolicLink", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.deleteMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "delete", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)V");
                this.getEncodingMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getEncoding", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)[B");
                this.getMimeTypeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getMimeType", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/lang/String;");
                this.getPathSeparatorMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getPathSeparator", "(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/lang/String;");
                this.getSeparatorMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getSeparator", "(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/lang/String;");
                this.getTempDirectoryMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getTempDirectory", "(Lorg/graalvm/polyglot/io/FileSystem;)Ljava/nio/file/Path;");
                this.isSameFileMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isSameFile", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)Z");
                this.moveMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "move", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/nio/file/Path;[B)V");
                this.newByteChannelMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "newByteChannel", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)Ljava/nio/channels/SeekableByteChannel;");
                this.newDirectoryStreamMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "newDirectoryStream", "(Lorg/graalvm/polyglot/io/FileSystem;JLjava/nio/file/Path;J)Ljava/nio/file/DirectoryStream;");
                this.parsePathMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "parsePath", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/lang/String;)Ljava/nio/file/Path;");
                this.parsePathMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "parsePath", "(Lorg/graalvm/polyglot/io/FileSystem;[B)Ljava/nio/file/Path;");
                this.readAttributesMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "readAttributes", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/lang/String;[B)[B");
                this.readSymbolicLinkMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "readSymbolicLink", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.setAttributeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "setAttribute", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;Ljava/lang/String;[B)V");
                this.setCurrentWorkingDirectoryMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "setCurrentWorkingDirectory", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)V");
                this.toAbsolutePathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toAbsolutePath", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.toRealPathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toRealPath", "(Lorg/graalvm/polyglot/io/FileSystem;Ljava/nio/file/Path;[B)Ljava/nio/file/Path;");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Charset> charsetMarshaller;
        private static final BinaryMarshaller<CopyOption> copyOptionMarshaller;
        private static final BinaryMarshaller<FileAttribute<?>> fileAttributeOfObjectMarshaller;
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<Map<String, Object>> mapOfStringObjectWithFileAttributeMapMarshaller;
        private static final BinaryMarshaller<Object> objectWithFileAttributeValueMarshaller;
        private static final BinaryMarshaller<Set<? extends AccessMode>> setOfExtendsAccessModeMarshaller;
        private static final BinaryMarshaller<Set<? extends OpenOption>> setOfExtendsOpenOptionMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void checkAccess(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Set<? extends AccessMode> set = setOfExtendsAccessModeMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                fileSystem.checkAccess(path, set, linkOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void copy(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                CopyOption[] copyOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    copyOptionArray = new CopyOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CopyOption copyOption;
                        copyOptionArray[i2] = copyOption = copyOptionMarshaller.read(binaryInput);
                    }
                } else {
                    copyOptionArray = null;
                }
                fileSystem.copy(path, path2, copyOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createDirectory(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute<?> fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                fileSystem.createDirectory(path, fileAttributeArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createLink(FileSystem fileSystem, Path path, Path path2) {
            try {
                fileSystem.createLink(path, path2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void createSymbolicLink(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute<?> fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                fileSystem.createSymbolicLink(path, path2, fileAttributeArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void delete(FileSystem fileSystem, Path path) {
            try {
                fileSystem.delete(path);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] getEncoding(FileSystem fileSystem, Path path) {
            try {
                Charset charset = fileSystem.getEncoding(path);
                int n2 = charsetMarshaller.inferSize(charset);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create(n2);
                charsetMarshaller.write(byteArrayBinaryOutput, charset);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getMimeType(FileSystem fileSystem, Path path) {
            try {
                String string = fileSystem.getMimeType(path);
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getPathSeparator(FileSystem fileSystem) {
            try {
                String string = fileSystem.getPathSeparator();
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String getSeparator(FileSystem fileSystem) {
            try {
                String string = fileSystem.getSeparator();
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getTempDirectory(FileSystem fileSystem) {
            try {
                Path path = fileSystem.getTempDirectory();
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isSameFile(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                int n2;
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    linkOptionArray = new LinkOption[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        LinkOption linkOption;
                        linkOptionArray[n2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                n2 = fileSystem.isSameFile(path, path2, linkOptionArray) ? 1 : 0;
                return n2 != 0;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void move(FileSystem fileSystem, Path path, Path path2, byte[] byArray) {
            try {
                CopyOption[] copyOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    copyOptionArray = new CopyOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CopyOption copyOption;
                        copyOptionArray[i2] = copyOption = copyOptionMarshaller.read(binaryInput);
                    }
                } else {
                    copyOptionArray = null;
                }
                fileSystem.move(path, path2, copyOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel newByteChannel(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                FileAttribute[] fileAttributeArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Set<? extends OpenOption> set = setOfExtendsOpenOptionMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    fileAttributeArray = new FileAttribute[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileAttribute<?> fileAttribute;
                        fileAttributeArray[i2] = fileAttribute = fileAttributeOfObjectMarshaller.read(binaryInput);
                    }
                } else {
                    fileAttributeArray = null;
                }
                SeekableByteChannel seekableByteChannel = fileSystem.newByteChannel(path, set, fileAttributeArray);
                return seekableByteChannel;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static DirectoryStream<Path> newDirectoryStream(FileSystem fileSystem, long l2, Path path, long l3) {
            try {
                DirectoryStream<Path> directoryStream = fileSystem.newDirectoryStream(path, l3 != 0L ? NativeDirectoryStreamFilterGen.create(NativeIsolate.get(l2), l3) : null);
                return directoryStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path parsePath(FileSystem fileSystem, String string) {
            try {
                Path path = fileSystem.parsePath(string);
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path parsePath(FileSystem fileSystem, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                URI uRI = uRIMarshaller.read(binaryInput);
                Path path = fileSystem.parsePath(uRI);
                return path;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] readAttributes(FileSystem fileSystem, Path path, String string, byte[] byArray) {
            try {
                Map<String, Object> map;
                int n2;
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    linkOptionArray = new LinkOption[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = (n2 = mapOfStringObjectWithFileAttributeMapMarshaller.inferSize(map = fileSystem.readAttributes(path, string, linkOptionArray))) > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n2) : BinaryOutput.create(byArray);
                mapOfStringObjectWithFileAttributeMapMarshaller.write(byteArrayBinaryOutput, map);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path readSymbolicLink(FileSystem fileSystem, Path path) {
            try {
                Path path2 = fileSystem.readSymbolicLink(path);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void setAttribute(FileSystem fileSystem, Path path, String string, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithFileAttributeValueMarshaller.read(binaryInput);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                fileSystem.setAttribute(path, string, object, linkOptionArray);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void setCurrentWorkingDirectory(FileSystem fileSystem, Path path) {
            try {
                fileSystem.setCurrentWorkingDirectory(path);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toAbsolutePath(FileSystem fileSystem, Path path) {
            try {
                Path path2 = fileSystem.toAbsolutePath(path);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toRealPath(FileSystem fileSystem, Path path, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                Path path2 = fileSystem.toRealPath(path, linkOptionArray);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            charsetMarshaller = jNIConfig.lookupMarshaller(Charset.class, new Class[0]);
            copyOptionMarshaller = jNIConfig.lookupMarshaller(CopyOption.class, new Class[0]);
            fileAttributeOfObjectMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<FileAttribute<?>>(){}, new Class[0]);
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            mapOfStringObjectWithFileAttributeMapMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Map<String, Object>>(){}, PolyglotJNIConfig.FileAttributeMap.class);
            objectWithFileAttributeValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.FileAttributeValue.class);
            setOfExtendsAccessModeMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<? extends AccessMode>>(){}, new Class[0]);
            setOfExtendsOpenOptionMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<? extends OpenOption>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }
    }
}

