/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.ReferenceUnavailableException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;

final class HSObjectReferences {
    private static final Message[] MESSAGES_BY_ID = InteropLibrary.getFactory().getMessages().toArray(new Message[0]);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final AtomicLong currentReferenceId = new AtomicLong(1L);
    private final Map<Long, TruffleObject> exportReferences = new ConcurrentHashMap<Long, TruffleObject>();

    HSObjectReferences() {
    }

    public long registerGuestObject(TruffleObject truffleObject) {
        long l2 = currentReferenceId.getAndIncrement();
        this.exportReferences.put(l2, truffleObject);
        return l2;
    }

    public TruffleObject getObject(long l2) {
        return this.exportReferences.get(l2);
    }

    public void releaseReference(long l2) {
        this.exportReferences.remove(l2);
    }

    public void releaseAllReferences() {
        this.exportReferences.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch(long l2, long l3, int n2, Object[] objectArray) throws Exception {
        Message message = MESSAGES_BY_ID[n2];
        TruffleObject truffleObject = this.exportReferences.get(l3);
        if (truffleObject == null) {
            throw new ReferenceUnavailableException(ReferenceUnavailableException.Kind.GUEST, l3);
        }
        Object object = NativeObjectHandles.resolve(l2, Object.class);
        Object object2 = EnterprisePolyglotImpl.instance.getAPIAccess().getContextReceiver(object);
        boolean bl = !EnterpriseEngineAccessor.ENGINE.isContextEntered(object2);
        Object object3 = null;
        if (bl) {
            object3 = EnterpriseEngineAccessor.ENGINE.enterInternalContext(null, object2);
        }
        try {
            ReflectionLibrary reflectionLibrary = ReflectionLibrary.getFactory().getUncached(truffleObject);
            Object[] objectArray2 = objectArray == null ? EMPTY_OBJECT_ARRAY : objectArray;
            Object object4 = reflectionLibrary.send(truffleObject, message, objectArray2);
            return object4;
        }
        finally {
            if (bl) {
                EnterpriseEngineAccessor.ENGINE.leaveInternalContext(null, object2, object3);
            }
        }
    }
}

