/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import com.oracle.truffle.regex.util.EmptyArrays;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public class LongArrayBuffer
extends AbstractArrayBuffer
implements Iterable<Long> {
    protected long[] buf;

    public LongArrayBuffer(int initialSize) {
        this.buf = new long[initialSize];
    }

    @Override
    int getBufferLength() {
        return this.buf.length;
    }

    @Override
    void grow(int newSize) {
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    public long get(int i2) {
        return this.buf[i2];
    }

    public void add(long v2) {
        if (this.length == this.buf.length) {
            this.grow(this.length * 2);
        }
        this.buf[this.length++] = v2;
    }

    public void addAll(long[] v2) {
        this.ensureCapacity(this.length + v2.length);
        System.arraycopy(v2, 0, this.buf, this.length, v2.length);
        this.length += v2.length;
    }

    public long pop() {
        return this.buf[--this.length];
    }

    public long peek() {
        return this.buf[this.length - 1];
    }

    public LongArrayBuffer asFixedSizeArray(int size) {
        this.ensureCapacity(size);
        this.length = size;
        return this;
    }

    public LongArrayBuffer asFixedSizeArray(int size, int initialValue) {
        this.ensureCapacity(size);
        Arrays.fill(this.buf, 0, size, (long)initialValue);
        this.length = size;
        return this;
    }

    public long[] toArray() {
        return this.isEmpty() ? EmptyArrays.LONG : Arrays.copyOf(this.buf, this.length);
    }

    public PrimitiveIterator.OfLong iterator() {
        return new LongArrayBufferIterator(this.buf, this.length);
    }

    private static final class LongArrayBufferIterator
    implements PrimitiveIterator.OfLong {
        private final long[] buf;
        private final int size;
        private int i = 0;

        private LongArrayBufferIterator(long[] buf, int size) {
            this.buf = buf;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public long nextLong() {
            return this.buf[this.i++];
        }
    }
}

