/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.CaseUnfoldingTrie;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBCharClassTrieNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Pair;

public class MultiCharacterCaseFolding {
    public static OracleDBCharClassTrieNode caseFoldUnfoldString(CaseFoldData.CaseFoldAlgorithm algorithm, int[] codepoints, CodePointSet encodingRange, boolean dropAsciiOnStart, boolean transitiveEquivalence, RegexASTBuilder astBuilder, OracleDBCharClassTrieNode root, CompilationBuffer compilationBuffer) {
        List<Integer> caseFolded = MultiCharacterCaseFolding.caseFold(algorithm, codepoints);
        List<CaseUnfoldingTrie.Unfolding> unfoldings = CaseUnfoldingTrie.findUnfoldings(algorithm, caseFolded);
        unfoldings = unfoldings.stream().filter(u2 -> encodingRange.contains(u2.getCodepoint())).collect(Collectors.toList());
        MultiCharacterCaseFolding.pushGroup(astBuilder);
        int start = 0;
        int end = 0;
        int unfoldingsStartIndex = 0;
        int unfoldingsEndIndex = 0;
        ArrayList<OracleDBCharClassTrieNode> leafNodes = null;
        if (root != null) {
            leafNodes = new ArrayList<OracleDBCharClassTrieNode>();
            leafNodes.add(root);
        }
        for (int i2 = 0; i2 < unfoldings.size(); ++i2) {
            CaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(i2);
            if (unfolding.getStart() >= end) {
                MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodes, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
                if (unfolding.getStart() > end) {
                    if (dropAsciiOnStart && end == 0 && RegexLexer.isAscii(caseFolded.get(end))) {
                        MultiCharacterCaseFolding.popGroup(astBuilder);
                        MultiCharacterCaseFolding.replaceCurTermWithDeadNode(astBuilder);
                        return null;
                    }
                    MultiCharacterCaseFolding.addString(astBuilder, leafNodes, caseFolded.subList(end, unfolding.getStart()), compilationBuffer);
                }
                start = unfolding.getStart();
                unfoldingsStartIndex = i2;
            }
            end = Math.max(end, unfolding.getEnd());
            unfoldingsEndIndex = i2 + 1;
        }
        MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodes, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
        if (end < caseFolded.size()) {
            if (dropAsciiOnStart && end == 0 && RegexLexer.isAscii(caseFolded.get(end))) {
                MultiCharacterCaseFolding.popGroup(astBuilder);
                MultiCharacterCaseFolding.replaceCurTermWithDeadNode(astBuilder);
                return null;
            }
            MultiCharacterCaseFolding.addString(astBuilder, leafNodes, caseFolded.subList(end, caseFolded.size()), compilationBuffer);
        }
        MultiCharacterCaseFolding.popGroup(astBuilder);
        if (leafNodes != null) {
            for (OracleDBCharClassTrieNode node : leafNodes) {
                node.setEndOfString();
            }
        }
        return root;
    }

    public static int[] caseFold(CaseFoldData.CaseFoldAlgorithm algorithm, int codePoint) {
        return CaseFoldData.getTable(algorithm).caseFold(codePoint);
    }

    private static boolean hasNoCaseFolding(CaseFoldData.CaseFoldAlgorithm algorithm, int codepoint) {
        return MultiCharacterCaseFolding.caseFold(algorithm, codepoint) == null;
    }

    private static List<Integer> caseFold(CaseFoldData.CaseFoldAlgorithm algorithm, int[] codepoints) {
        ArrayList<Integer> caseFolded = new ArrayList<Integer>();
        for (int codepoint : codepoints) {
            int[] folded = MultiCharacterCaseFolding.caseFold(algorithm, codepoint);
            if (folded == null) {
                caseFolded.add(codepoint);
                continue;
            }
            for (int foldedElem : folded) {
                caseFolded.add(foldedElem);
            }
        }
        return caseFolded;
    }

    private static void unfoldSegment(CaseFoldData.CaseFoldAlgorithm algorithm, RegexASTBuilder astBuilder, ArrayList<OracleDBCharClassTrieNode> leafNodes, List<Integer> caseFolded, List<CaseUnfoldingTrie.Unfolding> unfoldings, int start, int end, int backtrackingDepth, boolean dropAsciiOnStart, boolean transitiveEquivalence, CompilationBuffer compilationBuffer) {
        int unfoldingsNextIndex;
        if (backtrackingDepth > 12) {
            throw new UnsupportedRegexException("case-unfolding of case-insensitive string is too complex");
        }
        if (start == end) {
            return;
        }
        if (unfoldings.isEmpty()) {
            MultiCharacterCaseFolding.addString(astBuilder, leafNodes, caseFolded.subList(start, end), compilationBuffer);
            return;
        }
        CaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(0);
        if (unfolding.getStart() > start) {
            MultiCharacterCaseFolding.addString(astBuilder, leafNodes, caseFolded.subList(start, unfolding.getStart()), compilationBuffer);
            MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodes, caseFolded, unfoldings, unfolding.getStart(), end, backtrackingDepth, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
            return;
        }
        if (unfolding.getLength() > 1) {
            int unfoldingsNextIndex2;
            for (unfoldingsNextIndex2 = 1; unfoldingsNextIndex2 < unfoldings.size() && unfoldings.get(unfoldingsNextIndex2).getStart() < unfolding.getEnd(); ++unfoldingsNextIndex2) {
            }
            MultiCharacterCaseFolding.pushGroup(astBuilder);
            ArrayList<OracleDBCharClassTrieNode> leafNodesCopy = MultiCharacterCaseFolding.copy(leafNodes);
            MultiCharacterCaseFolding.addChar(astBuilder, leafNodesCopy, unfolding.getCodepoint(), compilationBuffer);
            MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodesCopy, caseFolded, unfoldings.subList(unfoldingsNextIndex2, unfoldings.size()), unfolding.getEnd(), end, backtrackingDepth + 1, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
            MultiCharacterCaseFolding.nextSequence(astBuilder);
            MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodes, caseFolded, unfoldings.subList(1, unfoldings.size()), start, end, backtrackingDepth + 1, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
            MultiCharacterCaseFolding.merge(leafNodes, leafNodesCopy);
            MultiCharacterCaseFolding.popGroup(astBuilder);
            return;
        }
        CodePointSetAccumulator acc = new CodePointSetAccumulator();
        if (!(dropAsciiOnStart && start == 0 && RegexLexer.isAscii(caseFolded.get(start)) || !transitiveEquivalence && !MultiCharacterCaseFolding.hasNoCaseFolding(algorithm, caseFolded.get(start)))) {
            acc.addCodePoint(caseFolded.get(start));
        }
        for (unfoldingsNextIndex = 0; unfoldingsNextIndex < unfoldings.size() && unfoldings.get(unfoldingsNextIndex).getStart() == start; ++unfoldingsNextIndex) {
            assert (unfoldings.get(unfoldingsNextIndex).getLength() == 1);
            int codepoint = unfoldings.get(unfoldingsNextIndex).getCodepoint();
            if (dropAsciiOnStart && start == 0 && RegexLexer.isAscii(codepoint)) continue;
            acc.addCodePoint(codepoint);
        }
        MultiCharacterCaseFolding.addCharClass(astBuilder, leafNodes, acc.toCodePointSet(), compilationBuffer);
        MultiCharacterCaseFolding.unfoldSegment(algorithm, astBuilder, leafNodes, caseFolded, unfoldings.subList(unfoldingsNextIndex, unfoldings.size()), start + 1, end, backtrackingDepth, dropAsciiOnStart, transitiveEquivalence, compilationBuffer);
    }

    private static ArrayList<OracleDBCharClassTrieNode> copy(ArrayList<OracleDBCharClassTrieNode> leafNodes) {
        return leafNodes == null ? null : new ArrayList<OracleDBCharClassTrieNode>(leafNodes);
    }

    private static void merge(ArrayList<OracleDBCharClassTrieNode> leafNodes, ArrayList<OracleDBCharClassTrieNode> leafNodesCopy) {
        if (leafNodes != null) {
            leafNodes.addAll(leafNodesCopy);
        }
    }

    private static void caseFoldCharClass(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass, BiConsumer<Integer, int[]> caseFoldItem) {
        CaseFoldData.getTable(algorithm).caseFold(charClass, caseFoldItem);
    }

    public static void caseClosure(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass, CodePointSetAccumulator tmp, BiPredicate<Integer, Integer> filter, CodePointSet allowedCodePoints, boolean transitiveEquivalence) {
        tmp.clear();
        MultiCharacterCaseFolding.caseFoldCharClass(algorithm, charClass, (from, to) -> {
            if (transitiveEquivalence || MultiCharacterCaseFolding.hasNoCaseFolding(algorithm, to[0])) {
                if (((int[])to).length == 1 && filter.test((Integer)from, to[0])) {
                    tmp.addCodePoint(to[0]);
                }
                for (int unfolding : CaseUnfoldingTrie.findSingleCharUnfoldings(algorithm, to)) {
                    if (unfolding == from || !filter.test((Integer)from, unfolding)) continue;
                    tmp.addCodePoint(unfolding);
                }
            }
        });
        for (Range r2 : charClass) {
            for (int codepoint = r2.lo; codepoint <= r2.hi; ++codepoint) {
                for (int unfolding : CaseUnfoldingTrie.findSingleCharUnfoldings(algorithm, codepoint)) {
                    if (!filter.test(codepoint, unfolding) || !transitiveEquivalence && !MultiCharacterCaseFolding.hasNoCaseFolding(algorithm, codepoint)) continue;
                    tmp.addCodePoint(unfolding);
                }
            }
        }
        tmp.intersectWith(allowedCodePoints);
        charClass.addSet(tmp.get());
    }

    public static List<Pair<Integer, int[]>> caseClosureMultiCodePoint(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass) {
        ArrayList<Pair<Integer, int[]>> multiCodePointExpansions = new ArrayList<Pair<Integer, int[]>>();
        MultiCharacterCaseFolding.caseFoldCharClass(algorithm, charClass, (from, to) -> {
            if (((int[])to).length > 1) {
                assert (!RegexLexer.isAscii(from));
                multiCodePointExpansions.add(Pair.create(from, to));
            }
        });
        return multiCodePointExpansions;
    }

    public static boolean equalsIgnoreCase(CaseFoldData.CaseFoldAlgorithm algorithm, int codePointA, int codePointB) {
        int[] foldedA = MultiCharacterCaseFolding.caseFold(algorithm, codePointA);
        int[] foldedB = MultiCharacterCaseFolding.caseFold(algorithm, codePointB);
        if (foldedA == null && foldedB == null) {
            return codePointA == codePointB;
        }
        if (foldedA == null) {
            return foldedB.length == 1 && codePointA == foldedB[0];
        }
        if (foldedB == null) {
            return foldedA.length == 1 && foldedA[0] == codePointB;
        }
        return Arrays.equals(foldedA, foldedB);
    }

    private static void pushGroup(RegexASTBuilder astBuilder) {
        if (astBuilder != null) {
            astBuilder.pushGroup();
        }
    }

    private static void nextSequence(RegexASTBuilder astBuilder) {
        if (astBuilder != null) {
            astBuilder.nextSequence();
        }
    }

    private static void popGroup(RegexASTBuilder astBuilder) {
        if (astBuilder != null) {
            astBuilder.popGroup();
        }
    }

    private static void replaceCurTermWithDeadNode(RegexASTBuilder astBuilder) {
        if (astBuilder != null) {
            astBuilder.replaceCurTermWithDeadNode();
        }
    }

    private static void addChar(RegexASTBuilder astBuilder, ArrayList<OracleDBCharClassTrieNode> leafNodes, int codepoint, CompilationBuffer compilationBuffer) {
        if (astBuilder != null) {
            astBuilder.addCharClass(CodePointSet.create(codepoint), true);
        }
        MultiCharacterCaseFolding.addCharClass(leafNodes, CodePointSet.create(codepoint), compilationBuffer);
    }

    private static void addCharClass(RegexASTBuilder astBuilder, ArrayList<OracleDBCharClassTrieNode> leafNodes, CodePointSet cps, CompilationBuffer compilationBuffer) {
        if (astBuilder != null) {
            astBuilder.addCharClass(cps, false);
        }
        MultiCharacterCaseFolding.addCharClass(leafNodes, cps, compilationBuffer);
    }

    private static void addCharClass(ArrayList<OracleDBCharClassTrieNode> leafNodes, CodePointSet cps, CompilationBuffer compilationBuffer) {
        if (leafNodes != null) {
            int i2 = 0;
            int length = leafNodes.size();
            while (i2 < length) {
                ArrayList<OracleDBCharClassTrieNode> children = leafNodes.get(i2).getOrAddChildren(cps, false, compilationBuffer);
                if (children == null || children.isEmpty()) {
                    leafNodes.remove(i2);
                    --length;
                    continue;
                }
                leafNodes.set(i2++, children.get(0));
                if (children.size() <= 1) continue;
                leafNodes.addAll(children.subList(1, children.size()));
            }
        }
    }

    private static void addString(RegexASTBuilder astBuilder, ArrayList<OracleDBCharClassTrieNode> leafNodes, List<Integer> codepoints, CompilationBuffer compilationBuffer) {
        for (int codepoint : codepoints) {
            MultiCharacterCaseFolding.addChar(astBuilder, leafNodes, codepoint, compilationBuffer);
        }
    }
}

