/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class OracleDBConstants {
    public static final EconomicMap<String, CodePointSet> POSIX_CHAR_CLASSES = EconomicMap.create(12);
    static final CodePointSet WORD_CHARACTERS;

    /*
     * Opcode count of 18569 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        POSIX_CHAR_CLASSES.put("alpha", CodePointSet.createNoDedup(65, 90, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 696, 699, 705, 711, 711, 713, 715, 718, 718, 721, 721, 729, 729, 736, 740, 748, 748, 750, 750, 768, 884, 886, 893, 895, 899, 902, 902, 904, 1013, 1015, 1153, 1155, 1369, 1376, 1416, 1419, 1420, 1424, 1455, 1466, 1466, 1477, 1477, 1479, 1522, 1525, 1535, 1552, 1562, 1568, 1631, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1775, 1786, 1788, 1791, 1791, 1806, 1806, 1808, 1983, 1994, 2037, 2042, 2045, 2048, 2095, 2111, 2141, 2143, 2183, 2185, 2191, 2194, 2273, 2275, 2304, 2308, 2363, 2382, 2403, 2417, 2533, 2544, 2545, 2556, 2556, 2558, 2661, 2672, 2677, 2679, 2789, 2802, 2917, 2929, 2929, 2936, 3045, 3067, 3173, 3184, 3190, 3200, 3203, 3205, 3301, 3312, 3406, 3408, 3415, 3423, 3429, 3450, 3557, 3568, 3571, 3573, 3630, 3632, 3646, 3648, 3653, 3655, 3661, 3676, 3791, 3802, 3840, 3864, 3865, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3972, 3974, 4029, 4038, 4038, 4045, 4045, 4059, 4159, 4176, 4239, 4250, 4253, 4256, 4346, 4348, 4959, 4989, 5007, 5018, 5119, 5121, 5740, 5743, 5759, 5761, 5786, 5789, 5866, 5870, 5940, 5943, 6099, 6103, 6103, 6108, 6111, 6122, 6127, 6138, 6143, 6155, 6157, 6159, 6159, 6170, 6463, 6465, 6467, 6480, 6607, 6619, 6621, 6656, 6685, 6688, 6783, 6794, 6799, 6810, 6815, 6823, 6823, 6830, 6991, 7019, 7027, 7039, 7087, 7098, 7163, 7168, 7226, 7242, 7247, 7258, 7293, 7296, 7359, 7368, 7378, 7380, 8124, 8126, 8126, 8130, 8140, 8144, 8156, 8160, 8172, 8176, 8188, 8191, 8191, 8213, 8213, 8293, 8293, 8305, 8307, 8335, 8351, 8385, 8447, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8488, 8488, 8490, 8490, 8492, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 8588, 8591, 9216, 9249, 9255, 9279, 9291, 9351, 11124, 11125, 11158, 11158, 11264, 11492, 11499, 11512, 11520, 11631, 11633, 11775, 11823, 11823, 11870, 12271, 12284, 12287, 12291, 12291, 12293, 12295, 12316, 12316, 12321, 12335, 12337, 12341, 12344, 12348, 12352, 12442, 12445, 12447, 12449, 12538, 12540, 12687, 12690, 12735, 12772, 12799, 12831, 12831, 13312, 19903, 19968, 42127, 42183, 42237, 42240, 42508, 42512, 42527, 42538, 42610, 42612, 42621, 42623, 42737, 42744, 42751, 42775, 42783, 42786, 42888, 42891, 43047, 43052, 43055, 43066, 43123, 43128, 43213, 43226, 43255, 43259, 43259, 43261, 43263, 43274, 43309, 43312, 43358, 43360, 43456, 43470, 43471, 43482, 43485, 43488, 43503, 43514, 43599, 43610, 43611, 43616, 43638, 43642, 43741, 43744, 43759, 43762, 43866, 43868, 43881, 43884, 44010, 44012, 44015, 44026, 55295, 57344, 64286, 64288, 64296, 64298, 64433, 64451, 64829, 64848, 64974, 64976, 65019, 65024, 65039, 65050, 65071, 65107, 65107, 65127, 65127, 65132, 65278, 65280, 65280, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65503, 65511, 65511, 65519, 65528, 65533, 65791, 65795, 65798, 65844, 65846, 65856, 65908, 65935, 65935, 65949, 65951, 65953, 65999, 66045, 66272, 66300, 66335, 66340, 66462, 66464, 66511, 66513, 66719, 66730, 66926, 66928, 67670, 67680, 67702, 67712, 67750, 67760, 67834, 67840, 67861, 67868, 67870, 67872, 67902, 67904, 68027, 68030, 68031, 68048, 68049, 68096, 68159, 68169, 68175, 68185, 68220, 68224, 68252, 68256, 68295, 68297, 68330, 68343, 68408, 68416, 68439, 68448, 68471, 68480, 68504, 68509, 68520, 68528, 68857, 68864, 68911, 68922, 69215, 69247, 69292, 69294, 69404, 69415, 69456, 69466, 69509, 69514, 69572, 69580, 69702, 69710, 69713, 69744, 69818, 69826, 69836, 69838, 69871, 69882, 69941, 69956, 70003, 70006, 70084, 70089, 70092, 70094, 70095, 70106, 70106, 70108, 70108, 70112, 70112, 70133, 70199, 70206, 70312, 70314, 70383, 70394, 70730, 70748, 70748, 70750, 70853, 70855, 70863, 70874, 71104, 71128, 71232, 71236, 71247, 71258, 71263, 71277, 71352, 71354, 71359, 71370, 71471, 71488, 71738, 71740, 71903, 71923, 72003, 72007, 72015, 72026, 72161, 72163, 72254, 72263, 72345, 72349, 72349, 72355, 72447, 72458, 72768, 72774, 72783, 72813, 72815, 72818, 73039, 73050, 73119, 73130, 73462, 73465, 73538, 73562, 73663, 73714, 73726, 73728, 74863, 74869, 77808, 77811, 78895, 78912, 92767, 92778, 92781, 92784, 92863, 92874, 92916, 92918, 92982, 92992, 92995, 92998, 93007, 93018, 93018, 93026, 93823, 93851, 94177, 94179, 113819, 113821, 113822, 113828, 118607, 118724, 118783, 119030, 119039, 119079, 119080, 119141, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119275, 119295, 119362, 119364, 119366, 119487, 119508, 119519, 119540, 119551, 119639, 119647, 119673, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120781, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121484, 123199, 123210, 123214, 123216, 123631, 123642, 123646, 123648, 124143, 124154, 125126, 125136, 125263, 125274, 125277, 125280, 126064, 126133, 126208, 126270, 126703, 126706, 126975, 127020, 127023, 127124, 127135, 127151, 127152, 127168, 127168, 127184, 127184, 127222, 127231, 127406, 127461, 127491, 127503, 127548, 127551, 127561, 127567, 127570, 127583, 127590, 127743, 128728, 128731, 128749, 128751, 128765, 128767, 128887, 128890, 128986, 128991, 129004, 129007, 129009, 129023, 129036, 129039, 129096, 129103, 129114, 129119, 129160, 129167, 129198, 129199, 129202, 129279, 129620, 129631, 129646, 129647, 129661, 129663, 129673, 129679, 129726, 129726, 129734, 129741, 129756, 129759, 129769, 129775, 129785, 129791, 129939, 129939, 129995, 130031, 130042, 917504, 917506, 917535, 917632, 1114109));
        POSIX_CHAR_CLASSES.put("blank", CodePointSet.createNoDedup(32, 32, 5760, 5760, 8192, 8202, 8232, 8233, 8239, 8239, 8287, 8287, 12288, 12288));
        POSIX_CHAR_CLASSES.put("cntrl", CodePointSet.createNoDedup(1, 31, 127, 159, 173, 173, 1536, 1541, 1564, 1564, 1757, 1757, 1807, 1807, 2192, 2193, 2274, 2274, 6158, 6158, 8203, 8207, 8234, 8238, 8288, 8292, 8294, 8303, 65279, 65279, 65529, 65531, 69821, 69821, 69837, 69837, 78896, 78911, 113824, 113827, 119155, 119162, 917505, 917505, 917536, 917631));
        POSIX_CHAR_CLASSES.put("digit", CodePointSet.createNoDedup(48, 57, 1632, 1641, 1776, 1785, 1984, 1993, 2406, 2415, 2534, 2543, 2662, 2671, 2790, 2799, 2918, 2927, 3046, 3055, 3174, 3183, 3302, 3311, 3430, 3439, 3558, 3567, 3664, 3673, 3792, 3801, 3872, 3881, 4160, 4169, 4240, 4249, 5870, 5872, 6112, 6121, 6160, 6169, 6470, 6479, 6608, 6617, 6784, 6793, 6800, 6809, 6992, 7001, 7088, 7097, 7232, 7241, 7248, 7257, 8544, 8578, 8581, 8584, 12295, 12295, 12321, 12329, 12344, 12346, 42528, 42537, 42726, 42735, 43216, 43225, 43264, 43273, 43472, 43481, 43504, 43513, 43600, 43609, 44016, 44025, 65296, 65305, 65856, 65908, 66369, 66369, 66378, 66378, 66513, 66517, 66720, 66729, 68912, 68921, 69734, 69743, 69872, 69881, 69942, 69951, 70096, 70105, 70384, 70393, 70736, 70745, 70864, 70873, 71248, 71257, 71360, 71369, 71472, 71481, 71904, 71913, 72016, 72025, 72784, 72793, 73040, 73049, 73120, 73129, 73552, 73561, 74752, 74862, 92768, 92777, 92864, 92873, 93008, 93017, 120782, 120831, 123200, 123209, 123632, 123641, 124144, 124153, 125264, 125273, 130032, 130041));
        POSIX_CHAR_CLASSES.put("graph", CodePointSet.createNoDedup(33, 126, 160, 172, 174, 177, 180, 184, 186, 187, 191, 1535, 1542, 1563, 1565, 1756, 1758, 1806, 1808, 2191, 2194, 2273, 2275, 2547, 2554, 2929, 2936, 3055, 3059, 3191, 3199, 3415, 3423, 3439, 3449, 3881, 3892, 4968, 4989, 5759, 5761, 6127, 6138, 6157, 6159, 6617, 6619, 8191, 8208, 8231, 8240, 8286, 8293, 8293, 8305, 8307, 8314, 8319, 8330, 8490, 8492, 8527, 8544, 8584, 8586, 9351, 9372, 9449, 9472, 10101, 10132, 11516, 11518, 12287, 12289, 12831, 12842, 12871, 12880, 12880, 12896, 12927, 12938, 12976, 12992, 43055, 43062, 55295, 57344, 65278, 65280, 65528, 65532, 65798, 65844, 65908, 65913, 65929, 65932, 66272, 66300, 66335, 66340, 67671, 67680, 67704, 67712, 67750, 67760, 67834, 67840, 67861, 67868, 68027, 68030, 68031, 68048, 68049, 68096, 68159, 68169, 68220, 68223, 68252, 68256, 68330, 68336, 68439, 68448, 68471, 68480, 68520, 68528, 68857, 68864, 69215, 69247, 69404, 69415, 69456, 69461, 69572, 69580, 69713, 69734, 69820, 69822, 69836, 69838, 70112, 70133, 71481, 71484, 71913, 71923, 72793, 72813, 73663, 73685, 78895, 78912, 93018, 93026, 93823, 93847, 113823, 113828, 119154, 119163, 119487, 119508, 119519, 119540, 119647, 119673, 125126, 125136, 126064, 126124, 126124, 126128, 126128, 126133, 126208, 126254, 126254, 126270, 127231, 127245, 917504, 917506, 917535, 917632, 1114109));
        POSIX_CHAR_CLASSES.put("lower", CodePointSet.createNoDedup(97, 122, 181, 181, 223, 246, 248, 255, 257, 257, 259, 259, 261, 261, 263, 263, 265, 265, 267, 267, 269, 269, 271, 271, 273, 273, 275, 275, 277, 277, 279, 279, 281, 281, 283, 283, 285, 285, 287, 287, 289, 289, 291, 291, 293, 293, 295, 295, 297, 297, 299, 299, 301, 301, 303, 303, 305, 305, 307, 307, 309, 309, 311, 312, 314, 314, 316, 316, 318, 318, 320, 320, 322, 322, 324, 324, 326, 326, 328, 329, 331, 331, 333, 333, 335, 335, 337, 337, 339, 339, 341, 341, 343, 343, 345, 345, 347, 347, 349, 349, 351, 351, 353, 353, 355, 355, 357, 357, 359, 359, 361, 361, 363, 363, 365, 365, 367, 367, 369, 369, 371, 371, 373, 373, 375, 375, 378, 378, 380, 380, 382, 384, 387, 387, 389, 389, 392, 392, 396, 397, 402, 402, 405, 405, 409, 411, 414, 414, 417, 417, 419, 419, 421, 421, 424, 424, 426, 427, 429, 429, 432, 432, 436, 436, 438, 438, 441, 442, 445, 447, 453, 454, 456, 457, 459, 460, 462, 462, 464, 464, 466, 466, 468, 468, 470, 470, 472, 472, 474, 474, 476, 477, 479, 479, 481, 481, 483, 483, 485, 485, 487, 487, 489, 489, 491, 491, 493, 493, 495, 496, 498, 499, 501, 501, 505, 505, 507, 507, 509, 509, 511, 511, 513, 513, 515, 515, 517, 517, 519, 519, 521, 521, 523, 523, 525, 525, 527, 527, 529, 529, 531, 531, 533, 533, 535, 535, 537, 537, 539, 539, 541, 541, 543, 543, 545, 545, 547, 547, 549, 549, 551, 551, 553, 553, 555, 555, 557, 557, 559, 559, 561, 561, 563, 569, 572, 572, 575, 576, 578, 578, 583, 583, 585, 585, 587, 587, 589, 589, 591, 659, 661, 687, 837, 837, 881, 881, 883, 883, 887, 887, 891, 893, 912, 912, 940, 974, 976, 977, 981, 983, 985, 985, 987, 987, 989, 989, 991, 991, 993, 993, 995, 995, 997, 997, 999, 999, 1001, 1001, 1003, 1003, 1005, 1005, 1007, 1011, 1013, 1013, 1016, 1016, 1019, 1020, 1072, 1119, 1121, 1121, 1123, 1123, 1125, 1125, 1127, 1127, 1129, 1129, 1131, 1131, 1133, 1133, 1135, 1135, 1137, 1137, 1139, 1139, 1141, 1141, 1143, 1143, 1145, 1145, 1147, 1147, 1149, 1149, 1151, 1151, 1153, 1153, 1163, 1163, 1165, 1165, 1167, 1167, 1169, 1169, 1171, 1171, 1173, 1173, 1175, 1175, 1177, 1177, 1179, 1179, 1181, 1181, 1183, 1183, 1185, 1185, 1187, 1187, 1189, 1189, 1191, 1191, 1193, 1193, 1195, 1195, 1197, 1197, 1199, 1199, 1201, 1201, 1203, 1203, 1205, 1205, 1207, 1207, 1209, 1209, 1211, 1211, 1213, 1213, 1215, 1215, 1218, 1218, 1220, 1220, 1222, 1222, 1224, 1224, 1226, 1226, 1228, 1228, 1230, 1231, 1233, 1233, 1235, 1235, 1237, 1237, 1239, 1239, 1241, 1241, 1243, 1243, 1245, 1245, 1247, 1247, 1249, 1249, 1251, 1251, 1253, 1253, 1255, 1255, 1257, 1257, 1259, 1259, 1261, 1261, 1263, 1263, 1265, 1265, 1267, 1267, 1269, 1269, 1271, 1271, 1273, 1273, 1275, 1275, 1277, 1277, 1279, 1279, 1281, 1281, 1283, 1283, 1285, 1285, 1287, 1287, 1289, 1289, 1291, 1291, 1293, 1293, 1295, 1295, 1297, 1297, 1299, 1299, 1301, 1301, 1303, 1303, 1305, 1305, 1307, 1307, 1309, 1309, 1311, 1311, 1313, 1313, 1315, 1315, 1317, 1317, 1319, 1319, 1321, 1321, 1323, 1323, 1325, 1325, 1327, 1327, 1376, 1416, 4304, 4346, 4349, 4351, 5112, 5117, 7296, 7304, 7424, 7467, 7531, 7543, 7545, 7578, 7681, 7681, 7683, 7683, 7685, 7685, 7687, 7687, 7689, 7689, 7691, 7691, 7693, 7693, 7695, 7695, 7697, 7697, 7699, 7699, 7701, 7701, 7703, 7703, 7705, 7705, 7707, 7707, 7709, 7709, 7711, 7711, 7713, 7713, 7715, 7715, 7717, 7717, 7719, 7719, 7721, 7721, 7723, 7723, 7725, 7725, 7727, 7727, 7729, 7729, 7731, 7731, 7733, 7733, 7735, 7735, 7737, 7737, 7739, 7739, 7741, 7741, 7743, 7743, 7745, 7745, 7747, 7747, 7749, 7749, 7751, 7751, 7753, 7753, 7755, 7755, 7757, 7757, 7759, 7759, 7761, 7761, 7763, 7763, 7765, 7765, 7767, 7767, 7769, 7769, 7771, 7771, 7773, 7773, 7775, 7775, 7777, 7777, 7779, 7779, 7781, 7781, 7783, 7783, 7785, 7785, 7787, 7787, 7789, 7789, 7791, 7791, 7793, 7793, 7795, 7795, 7797, 7797, 7799, 7799, 7801, 7801, 7803, 7803, 7805, 7805, 7807, 7807, 7809, 7809, 7811, 7811, 7813, 7813, 7815, 7815, 7817, 7817, 7819, 7819, 7821, 7821, 7823, 7823, 7825, 7825, 7827, 7827, 7829, 7837, 7839, 7839, 7841, 7841, 7843, 7843, 7845, 7845, 7847, 7847, 7849, 7849, 7851, 7851, 7853, 7853, 7855, 7855, 7857, 7857, 7859, 7859, 7861, 7861, 7863, 7863, 7865, 7865, 7867, 7867, 7869, 7869, 7871, 7871, 7873, 7873, 7875, 7875, 7877, 7877, 7879, 7879, 7881, 7881, 7883, 7883, 7885, 7885, 7887, 7887, 7889, 7889, 7891, 7891, 7893, 7893, 7895, 7895, 7897, 7897, 7899, 7899, 7901, 7901, 7903, 7903, 7905, 7905, 7907, 7907, 7909, 7909, 7911, 7911, 7913, 7913, 7915, 7915, 7917, 7917, 7919, 7919, 7921, 7921, 7923, 7923, 7925, 7925, 7927, 7927, 7929, 7929, 7931, 7931, 7933, 7933, 7935, 7943, 7952, 7957, 7968, 7975, 7984, 7991, 8000, 8005, 8016, 8023, 8032, 8039, 8048, 8061, 8064, 8071, 8080, 8087, 8096, 8103, 8112, 8116, 8118, 8119, 8126, 8126, 8130, 8132, 8134, 8135, 8144, 8147, 8150, 8151, 8160, 8167, 8178, 8180, 8182, 8183, 8319, 8319, 8458, 8458, 8462, 8463, 8467, 8467, 8495, 8495, 8500, 8500, 8505, 8505, 8508, 8509, 8518, 8521, 8526, 8526, 8560, 8575, 8580, 8580, 9424, 9449, 11312, 11359, 11361, 11361, 11365, 11366, 11368, 11368, 11370, 11370, 11372, 11372, 11377, 11377, 11379, 11380, 11382, 11387, 11393, 11393, 11395, 11395, 11397, 11397, 11399, 11399, 11401, 11401, 11403, 11403, 11405, 11405, 11407, 11407, 11409, 11409, 11411, 11411, 11413, 11413, 11415, 11415, 11417, 11417, 11419, 11419, 11421, 11421, 11423, 11423, 11425, 11425, 11427, 11427, 11429, 11429, 11431, 11431, 11433, 11433, 11435, 11435, 11437, 11437, 11439, 11439, 11441, 11441, 11443, 11443, 11445, 11445, 11447, 11447, 11449, 11449, 11451, 11451, 11453, 11453, 11455, 11455, 11457, 11457, 11459, 11459, 11461, 11461, 11463, 11463, 11465, 11465, 11467, 11467, 11469, 11469, 11471, 11471, 11473, 11473, 11475, 11475, 11477, 11477, 11479, 11479, 11481, 11481, 11483, 11483, 11485, 11485, 11487, 11487, 11489, 11489, 11491, 11492, 11500, 11500, 11502, 11502, 11507, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 42561, 42561, 42563, 42563, 42565, 42565, 42567, 42567, 42569, 42569, 42571, 42571, 42573, 42573, 42575, 42575, 42577, 42577, 42579, 42579, 42581, 42581, 42583, 42583, 42585, 42585, 42587, 42587, 42589, 42589, 42591, 42591, 42593, 42593, 42595, 42595, 42597, 42597, 42599, 42599, 42601, 42601, 42603, 42603, 42605, 42605, 42625, 42625, 42627, 42627, 42629, 42629, 42631, 42631, 42633, 42633, 42635, 42635, 42637, 42637, 42639, 42639, 42641, 42641, 42643, 42643, 42645, 42645, 42647, 42647, 42649, 42649, 42651, 42651, 42787, 42787, 42789, 42789, 42791, 42791, 42793, 42793, 42795, 42795, 42797, 42797, 42799, 42801, 42803, 42803, 42805, 42805, 42807, 42807, 42809, 42809, 42811, 42811, 42813, 42813, 42815, 42815, 42817, 42817, 42819, 42819, 42821, 42821, 42823, 42823, 42825, 42825, 42827, 42827, 42829, 42829, 42831, 42831, 42833, 42833, 42835, 42835, 42837, 42837, 42839, 42839, 42841, 42841, 42843, 42843, 42845, 42845, 42847, 42847, 42849, 42849, 42851, 42851, 42853, 42853, 42855, 42855, 42857, 42857, 42859, 42859, 42861, 42861, 42863, 42863, 42865, 42872, 42874, 42874, 42876, 42876, 42879, 42879, 42881, 42881, 42883, 42883, 42885, 42885, 42887, 42887, 42892, 42892, 42894, 42894, 42897, 42897, 42899, 42901, 42903, 42903, 42905, 42905, 42907, 42907, 42909, 42909, 42911, 42911, 42913, 42913, 42915, 42915, 42917, 42917, 42919, 42919, 42921, 42921, 42927, 42927, 42933, 42933, 42935, 42935, 42937, 42937, 42939, 42939, 42941, 42941, 42943, 42943, 42945, 42945, 42947, 42947, 42952, 42952, 42954, 42954, 42961, 42961, 42963, 42963, 42965, 42965, 42967, 42967, 42969, 42969, 42998, 42998, 43002, 43002, 43824, 43866, 43872, 43880, 43888, 43967, 64256, 64262, 64275, 64279, 65345, 65370, 66600, 66639, 66776, 66811, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 68800, 68850, 71872, 71903, 93792, 93823, 119834, 119859, 119886, 119892, 119894, 119911, 119938, 119963, 119990, 119993, 119995, 119995, 119997, 120003, 120005, 120015, 120042, 120067, 120094, 120119, 120146, 120171, 120198, 120223, 120250, 120275, 120302, 120327, 120354, 120379, 120406, 120431, 120458, 120485, 120514, 120538, 120540, 120545, 120572, 120596, 120598, 120603, 120630, 120654, 120656, 120661, 120688, 120712, 120714, 120719, 120746, 120770, 120772, 120777, 120779, 120779, 122624, 122633, 122635, 122654, 122661, 122666, 125218, 125251));
        POSIX_CHAR_CLASSES.put("print", CodePointSet.createNoDedup(32, 126, 160, 172, 174, 1535, 1542, 1563, 1565, 1756, 1758, 1806, 1808, 2191, 2194, 2273, 2275, 6157, 6159, 8202, 8208, 8233, 8239, 8287, 8293, 8293, 8304, 55295, 57344, 65278, 65280, 65528, 65532, 69820, 69822, 69836, 69838, 78895, 78912, 113823, 113828, 119154, 119163, 917504, 917506, 917535, 917632, 1114109));
        POSIX_CHAR_CLASSES.put("punct", CodePointSet.createNoDedup(33, 47, 58, 64, 91, 96, 123, 126, 160, 169, 171, 172, 174, 177, 180, 180, 182, 184, 187, 187, 191, 191, 215, 215, 247, 247, 697, 698, 706, 710, 712, 712, 716, 717, 719, 720, 722, 728, 730, 735, 741, 747, 749, 749, 751, 767, 885, 885, 894, 894, 900, 901, 903, 903, 1014, 1014, 1154, 1154, 1370, 1375, 1417, 1418, 1421, 1423, 1456, 1465, 1467, 1476, 1478, 1478, 1523, 1524, 1542, 1551, 1563, 1563, 1565, 1567, 1642, 1645, 1748, 1748, 1758, 1758, 1769, 1769, 1789, 1790, 1792, 1805, 2038, 2041, 2046, 2047, 2096, 2110, 2142, 2142, 2184, 2184, 2305, 2307, 2364, 2381, 2404, 2405, 2416, 2416, 2546, 2547, 2554, 2555, 2557, 2557, 2678, 2678, 2800, 2801, 2928, 2928, 3059, 3066, 3191, 3191, 3199, 3199, 3204, 3204, 3407, 3407, 3449, 3449, 3572, 3572, 3631, 3631, 3647, 3647, 3654, 3654, 3662, 3663, 3674, 3675, 3841, 3863, 3866, 3871, 3892, 3892, 3894, 3894, 3896, 3896, 3898, 3901, 3973, 3973, 4030, 4037, 4039, 4044, 4046, 4058, 4170, 4175, 4254, 4255, 4347, 4347, 4960, 4968, 5008, 5017, 5120, 5120, 5741, 5742, 5787, 5788, 5867, 5869, 5941, 5942, 6100, 6102, 6104, 6107, 6144, 6154, 6464, 6464, 6468, 6469, 6622, 6655, 6686, 6687, 6816, 6822, 6824, 6829, 7002, 7018, 7028, 7038, 7164, 7167, 7227, 7231, 7294, 7295, 7360, 7367, 7379, 7379, 8125, 8125, 8127, 8129, 8141, 8143, 8157, 8159, 8173, 8175, 8189, 8190, 8208, 8212, 8214, 8231, 8240, 8286, 8314, 8319, 8330, 8334, 8352, 8384, 8448, 8449, 8451, 8454, 8456, 8457, 8468, 8468, 8470, 8472, 8478, 8483, 8485, 8487, 8489, 8489, 8494, 8494, 8506, 8507, 8512, 8516, 8522, 8525, 8527, 8527, 8586, 8587, 8592, 9215, 9250, 9254, 9280, 9290, 9372, 9449, 9472, 10101, 10132, 11123, 11126, 11157, 11159, 11263, 11493, 11498, 11513, 11516, 11518, 11519, 11632, 11632, 11776, 11822, 11824, 11869, 12272, 12283, 12289, 12290, 12292, 12292, 12296, 12315, 12317, 12320, 12336, 12336, 12342, 12343, 12349, 12351, 12443, 12444, 12448, 12448, 12539, 12539, 12688, 12689, 12736, 12771, 12800, 12830, 12842, 12871, 12880, 12880, 12896, 12927, 12938, 12976, 12992, 13311, 19904, 19967, 42128, 42182, 42238, 42239, 42509, 42511, 42611, 42611, 42622, 42622, 42738, 42743, 42752, 42774, 42784, 42785, 42889, 42890, 43048, 43051, 43062, 43065, 43124, 43127, 43214, 43215, 43256, 43258, 43260, 43260, 43310, 43311, 43359, 43359, 43457, 43469, 43486, 43487, 43612, 43615, 43639, 43641, 43742, 43743, 43760, 43761, 43867, 43867, 43882, 43883, 44011, 44011, 64287, 64287, 64297, 64297, 64434, 64450, 64830, 64847, 64975, 64975, 65020, 65023, 65040, 65049, 65072, 65106, 65108, 65126, 65128, 65131, 65281, 65295, 65306, 65312, 65339, 65342, 65344, 65344, 65371, 65381, 65504, 65510, 65512, 65518, 65532, 65532, 65792, 65794, 65847, 65855, 65913, 65929, 65932, 65934, 65936, 65948, 65952, 65952, 66000, 66044, 66463, 66463, 66512, 66512, 66927, 66927, 67671, 67671, 67703, 67704, 67871, 67871, 67903, 67903, 68176, 68184, 68223, 68223, 68296, 68296, 68336, 68342, 68409, 68415, 68505, 68508, 69293, 69293, 69461, 69465, 69510, 69513, 69703, 69709, 69819, 69820, 69822, 69825, 69952, 69955, 70004, 70005, 70085, 70088, 70093, 70093, 70107, 70107, 70109, 70111, 70200, 70205, 70313, 70313, 70731, 70735, 70746, 70747, 70749, 70749, 70854, 70854, 71105, 71127, 71233, 71235, 71264, 71276, 71353, 71353, 71484, 71487, 71739, 71739, 72004, 72006, 72162, 72162, 72255, 72262, 72346, 72348, 72350, 72354, 72448, 72457, 72769, 72773, 72816, 72817, 73463, 73464, 73539, 73551, 73685, 73713, 73727, 73727, 74864, 74868, 77809, 77810, 92782, 92783, 92917, 92917, 92983, 92991, 92996, 92997, 93847, 93850, 94178, 94178, 113820, 113820, 113823, 113823, 118608, 118723, 118784, 119029, 119040, 119078, 119081, 119140, 119146, 119148, 119171, 119172, 119180, 119209, 119214, 119274, 119296, 119361, 119365, 119365, 119552, 119638, 120513, 120513, 120539, 120539, 120571, 120571, 120597, 120597, 120629, 120629, 120655, 120655, 120687, 120687, 120713, 120713, 120745, 120745, 120771, 120771, 120832, 121343, 121399, 121402, 121453, 121460, 121462, 121475, 121477, 121483, 123215, 123215, 123647, 123647, 125278, 125279, 126124, 126124, 126128, 126128, 126254, 126254, 126704, 126705, 126976, 127019, 127024, 127123, 127136, 127150, 127153, 127167, 127169, 127183, 127185, 127221, 127245, 127405, 127462, 127490, 127504, 127547, 127552, 127560, 127568, 127569, 127584, 127589, 127744, 128727, 128732, 128748, 128752, 128764, 128768, 128886, 128891, 128985, 128992, 129003, 129008, 129008, 129024, 129035, 129040, 129095, 129104, 129113, 129120, 129159, 129168, 129197, 129200, 129201, 129280, 129619, 129632, 129645, 129648, 129660, 129664, 129672, 129680, 129725, 129727, 129733, 129742, 129755, 129760, 129768, 129776, 129784, 129792, 129938, 129940, 129994));
        POSIX_CHAR_CLASSES.put("space", CodePointSet.createNoDedup(9, 13, 32, 32, 5760, 5760, 8192, 8202, 8232, 8233, 8239, 8239, 8287, 8287, 12288, 12288));
        POSIX_CHAR_CLASSES.put("upper", CodePointSet.createNoDedup(65, 90, 192, 214, 216, 222, 256, 256, 258, 258, 260, 260, 262, 262, 264, 264, 266, 266, 268, 268, 270, 270, 272, 272, 274, 274, 276, 276, 278, 278, 280, 280, 282, 282, 284, 284, 286, 286, 288, 288, 290, 290, 292, 292, 294, 294, 296, 296, 298, 298, 300, 300, 302, 302, 304, 304, 306, 306, 308, 308, 310, 310, 313, 313, 315, 315, 317, 317, 319, 319, 321, 321, 323, 323, 325, 325, 327, 327, 330, 330, 332, 332, 334, 334, 336, 336, 338, 338, 340, 340, 342, 342, 344, 344, 346, 346, 348, 348, 350, 350, 352, 352, 354, 354, 356, 356, 358, 358, 360, 360, 362, 362, 364, 364, 366, 366, 368, 368, 370, 370, 372, 372, 374, 374, 376, 377, 379, 379, 381, 381, 385, 386, 388, 388, 390, 391, 393, 395, 398, 401, 403, 404, 406, 408, 412, 413, 415, 416, 418, 418, 420, 420, 422, 423, 425, 425, 428, 428, 430, 431, 433, 435, 437, 437, 439, 440, 444, 444, 452, 453, 455, 456, 458, 459, 461, 461, 463, 463, 465, 465, 467, 467, 469, 469, 471, 471, 473, 473, 475, 475, 478, 478, 480, 480, 482, 482, 484, 484, 486, 486, 488, 488, 490, 490, 492, 492, 494, 494, 497, 498, 500, 500, 502, 504, 506, 506, 508, 508, 510, 510, 512, 512, 514, 514, 516, 516, 518, 518, 520, 520, 522, 522, 524, 524, 526, 526, 528, 528, 530, 530, 532, 532, 534, 534, 536, 536, 538, 538, 540, 540, 542, 542, 544, 544, 546, 546, 548, 548, 550, 550, 552, 552, 554, 554, 556, 556, 558, 558, 560, 560, 562, 562, 570, 571, 573, 574, 577, 577, 579, 582, 584, 584, 586, 586, 588, 588, 590, 590, 880, 880, 882, 882, 886, 886, 895, 895, 902, 902, 904, 906, 908, 908, 910, 911, 913, 929, 931, 939, 975, 975, 978, 980, 984, 984, 986, 986, 988, 988, 990, 990, 992, 992, 994, 994, 996, 996, 998, 998, 1000, 1000, 1002, 1002, 1004, 1004, 1006, 1006, 1012, 1012, 1015, 1015, 1017, 1018, 1021, 1071, 1120, 1120, 1122, 1122, 1124, 1124, 1126, 1126, 1128, 1128, 1130, 1130, 1132, 1132, 1134, 1134, 1136, 1136, 1138, 1138, 1140, 1140, 1142, 1142, 1144, 1144, 1146, 1146, 1148, 1148, 1150, 1150, 1152, 1152, 1162, 1162, 1164, 1164, 1166, 1166, 1168, 1168, 1170, 1170, 1172, 1172, 1174, 1174, 1176, 1176, 1178, 1178, 1180, 1180, 1182, 1182, 1184, 1184, 1186, 1186, 1188, 1188, 1190, 1190, 1192, 1192, 1194, 1194, 1196, 1196, 1198, 1198, 1200, 1200, 1202, 1202, 1204, 1204, 1206, 1206, 1208, 1208, 1210, 1210, 1212, 1212, 1214, 1214, 1216, 1217, 1219, 1219, 1221, 1221, 1223, 1223, 1225, 1225, 1227, 1227, 1229, 1229, 1232, 1232, 1234, 1234, 1236, 1236, 1238, 1238, 1240, 1240, 1242, 1242, 1244, 1244, 1246, 1246, 1248, 1248, 1250, 1250, 1252, 1252, 1254, 1254, 1256, 1256, 1258, 1258, 1260, 1260, 1262, 1262, 1264, 1264, 1266, 1266, 1268, 1268, 1270, 1270, 1272, 1272, 1274, 1274, 1276, 1276, 1278, 1278, 1280, 1280, 1282, 1282, 1284, 1284, 1286, 1286, 1288, 1288, 1290, 1290, 1292, 1292, 1294, 1294, 1296, 1296, 1298, 1298, 1300, 1300, 1302, 1302, 1304, 1304, 1306, 1306, 1308, 1308, 1310, 1310, 1312, 1312, 1314, 1314, 1316, 1316, 1318, 1318, 1320, 1320, 1322, 1322, 1324, 1324, 1326, 1326, 1329, 1366, 4256, 4293, 4295, 4295, 4301, 4301, 5024, 5109, 7312, 7354, 7357, 7359, 7680, 7680, 7682, 7682, 7684, 7684, 7686, 7686, 7688, 7688, 7690, 7690, 7692, 7692, 7694, 7694, 7696, 7696, 7698, 7698, 7700, 7700, 7702, 7702, 7704, 7704, 7706, 7706, 7708, 7708, 7710, 7710, 7712, 7712, 7714, 7714, 7716, 7716, 7718, 7718, 7720, 7720, 7722, 7722, 7724, 7724, 7726, 7726, 7728, 7728, 7730, 7730, 7732, 7732, 7734, 7734, 7736, 7736, 7738, 7738, 7740, 7740, 7742, 7742, 7744, 7744, 7746, 7746, 7748, 7748, 7750, 7750, 7752, 7752, 7754, 7754, 7756, 7756, 7758, 7758, 7760, 7760, 7762, 7762, 7764, 7764, 7766, 7766, 7768, 7768, 7770, 7770, 7772, 7772, 7774, 7774, 7776, 7776, 7778, 7778, 7780, 7780, 7782, 7782, 7784, 7784, 7786, 7786, 7788, 7788, 7790, 7790, 7792, 7792, 7794, 7794, 7796, 7796, 7798, 7798, 7800, 7800, 7802, 7802, 7804, 7804, 7806, 7806, 7808, 7808, 7810, 7810, 7812, 7812, 7814, 7814, 7816, 7816, 7818, 7818, 7820, 7820, 7822, 7822, 7824, 7824, 7826, 7826, 7828, 7828, 7838, 7838, 7840, 7840, 7842, 7842, 7844, 7844, 7846, 7846, 7848, 7848, 7850, 7850, 7852, 7852, 7854, 7854, 7856, 7856, 7858, 7858, 7860, 7860, 7862, 7862, 7864, 7864, 7866, 7866, 7868, 7868, 7870, 7870, 7872, 7872, 7874, 7874, 7876, 7876, 7878, 7878, 7880, 7880, 7882, 7882, 7884, 7884, 7886, 7886, 7888, 7888, 7890, 7890, 7892, 7892, 7894, 7894, 7896, 7896, 7898, 7898, 7900, 7900, 7902, 7902, 7904, 7904, 7906, 7906, 7908, 7908, 7910, 7910, 7912, 7912, 7914, 7914, 7916, 7916, 7918, 7918, 7920, 7920, 7922, 7922, 7924, 7924, 7926, 7926, 7928, 7928, 7930, 7930, 7932, 7932, 7934, 7934, 7944, 7951, 7960, 7965, 7976, 7983, 7992, 7999, 8008, 8013, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8031, 8040, 8047, 8072, 8079, 8088, 8095, 8104, 8111, 8120, 8124, 8136, 8140, 8152, 8155, 8168, 8172, 8184, 8188, 8450, 8450, 8455, 8455, 8459, 8461, 8464, 8466, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8496, 8499, 8510, 8511, 8517, 8517, 8544, 8559, 8579, 8579, 9398, 9423, 11264, 11311, 11360, 11360, 11362, 11364, 11367, 11367, 11369, 11369, 11371, 11371, 11373, 11376, 11378, 11378, 11381, 11381, 11390, 11392, 11394, 11394, 11396, 11396, 11398, 11398, 11400, 11400, 11402, 11402, 11404, 11404, 11406, 11406, 11408, 11408, 11410, 11410, 11412, 11412, 11414, 11414, 11416, 11416, 11418, 11418, 11420, 11420, 11422, 11422, 11424, 11424, 11426, 11426, 11428, 11428, 11430, 11430, 11432, 11432, 11434, 11434, 11436, 11436, 11438, 11438, 11440, 11440, 11442, 11442, 11444, 11444, 11446, 11446, 11448, 11448, 11450, 11450, 11452, 11452, 11454, 11454, 11456, 11456, 11458, 11458, 11460, 11460, 11462, 11462, 11464, 11464, 11466, 11466, 11468, 11468, 11470, 11470, 11472, 11472, 11474, 11474, 11476, 11476, 11478, 11478, 11480, 11480, 11482, 11482, 11484, 11484, 11486, 11486, 11488, 11488, 11490, 11490, 11499, 11499, 11501, 11501, 11506, 11506, 42560, 42560, 42562, 42562, 42564, 42564, 42566, 42566, 42568, 42568, 42570, 42570, 42572, 42572, 42574, 42574, 42576, 42576, 42578, 42578, 42580, 42580, 42582, 42582, 42584, 42584, 42586, 42586, 42588, 42588, 42590, 42590, 42592, 42592, 42594, 42594, 42596, 42596, 42598, 42598, 42600, 42600, 42602, 42602, 42604, 42604, 42624, 42624, 42626, 42626, 42628, 42628, 42630, 42630, 42632, 42632, 42634, 42634, 42636, 42636, 42638, 42638, 42640, 42640, 42642, 42642, 42644, 42644, 42646, 42646, 42648, 42648, 42650, 42650, 42786, 42786, 42788, 42788, 42790, 42790, 42792, 42792, 42794, 42794, 42796, 42796, 42798, 42798, 42802, 42802, 42804, 42804, 42806, 42806, 42808, 42808, 42810, 42810, 42812, 42812, 42814, 42814, 42816, 42816, 42818, 42818, 42820, 42820, 42822, 42822, 42824, 42824, 42826, 42826, 42828, 42828, 42830, 42830, 42832, 42832, 42834, 42834, 42836, 42836, 42838, 42838, 42840, 42840, 42842, 42842, 42844, 42844, 42846, 42846, 42848, 42848, 42850, 42850, 42852, 42852, 42854, 42854, 42856, 42856, 42858, 42858, 42860, 42860, 42862, 42862, 42873, 42873, 42875, 42875, 42877, 42878, 42880, 42880, 42882, 42882, 42884, 42884, 42886, 42886, 42891, 42891, 42893, 42893, 42896, 42896, 42898, 42898, 42902, 42902, 42904, 42904, 42906, 42906, 42908, 42908, 42910, 42910, 42912, 42912, 42914, 42914, 42916, 42916, 42918, 42918, 42920, 42920, 42922, 42926, 42928, 42932, 42934, 42934, 42936, 42936, 42938, 42938, 42940, 42940, 42942, 42942, 42944, 42944, 42946, 42946, 42948, 42951, 42953, 42953, 42960, 42960, 42966, 42966, 42968, 42968, 42997, 42997, 65313, 65338, 66560, 66599, 66736, 66771, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 68736, 68786, 71840, 71871, 93760, 93791, 119808, 119833, 119860, 119885, 119912, 119937, 119964, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119989, 120016, 120041, 120068, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120120, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120172, 120197, 120224, 120249, 120276, 120301, 120328, 120353, 120380, 120405, 120432, 120457, 120488, 120512, 120546, 120570, 120604, 120628, 120662, 120686, 120720, 120744, 120778, 120778, 125184, 125217));
        POSIX_CHAR_CLASSES.put("xdigit", CodePointSet.createNoDedup(48, 57, 65, 70, 97, 102, 65296, 65305, 65313, 65318, 65345, 65350));
        POSIX_CHAR_CLASSES.put("alnum", ((CodePointSet)POSIX_CHAR_CLASSES.get("alpha")).union((CodePointSet)POSIX_CHAR_CLASSES.get("digit")));
        WORD_CHARACTERS = ((CodePointSet)POSIX_CHAR_CLASSES.get("alnum")).union(CodePointSet.create(95));
    }
}

