/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetProviderICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.IntTrie;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.PropsVectors;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UTF16;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public final class CharsetSelector {
    private IntTrie trie;
    private int[] pv;
    private String[] encodings;

    private void generateSelectorData(PropsVectors pvec, UnicodeSet excludedCodePoints, int mappingTypes) {
        int columns = (this.encodings.length + 31) / 32;
        for (int col = 0; col < columns; ++col) {
            pvec.setValue(0x110001, 0x110001, col, -1, -1);
        }
        for (int i2 = 0; i2 < this.encodings.length; ++i2) {
            Charset testCharset = CharsetICU.forNameICU(this.encodings[i2]);
            UnicodeSet unicodePointSet = new UnicodeSet();
            ((CharsetICU)testCharset).getUnicodeSet(unicodePointSet, mappingTypes);
            int column = i2 / 32;
            int mask = 1 << i2 % 32;
            int itemCount = unicodePointSet.getRangeCount();
            for (int j2 = 0; j2 < itemCount; ++j2) {
                int startChar = unicodePointSet.getRangeStart(j2);
                int endChar = unicodePointSet.getRangeEnd(j2);
                pvec.setValue(startChar, endChar, column, -1, mask);
            }
        }
        if (!excludedCodePoints.isEmpty()) {
            int itemCount = excludedCodePoints.getRangeCount();
            for (int j3 = 0; j3 < itemCount; ++j3) {
                int startChar = excludedCodePoints.getRangeStart(j3);
                int endChar = excludedCodePoints.getRangeEnd(j3);
                for (int col = 0; col < columns; ++col) {
                    pvec.setValue(startChar, endChar, col, -1, -1);
                }
            }
        }
        this.trie = pvec.compactToTrieWithRowIndexes();
        this.pv = pvec.getCompactedArray();
    }

    private boolean intersectMasks(int[] dest, int pvIndex, int len) {
        int oredDest = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = i2;
            int n3 = dest[n2] & this.pv[pvIndex + i2];
            dest[n2] = n3;
            oredDest |= n3;
        }
        return oredDest == 0;
    }

    private List<String> selectForMask(int[] mask) {
        ArrayList<String> result = new ArrayList<String>();
        int columns = (this.encodings.length + 31) / 32;
        int numOnes = this.countOnes(mask, columns);
        if (numOnes > 0) {
            int k2 = 0;
            for (int j2 = 0; j2 < columns; ++j2) {
                int v2 = mask[j2];
                for (int i2 = 0; i2 < 32 && k2 < this.encodings.length; ++i2, ++k2) {
                    if ((v2 & 1) != 0) {
                        result.add(this.encodings[k2]);
                    }
                    v2 >>= 1;
                }
            }
        }
        return result;
    }

    private int countOnes(int[] mask, int len) {
        int totalOnes = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int ent = mask[i2];
            while (ent != 0) {
                ent &= ent - 1;
                ++totalOnes;
            }
        }
        return totalOnes;
    }

    public CharsetSelector(List<String> charsetList, UnicodeSet excludedCodePoints, int mappingTypes) {
        if (mappingTypes != 1 && mappingTypes != 0) {
            throw new IllegalArgumentException("Unsupported mappingTypes");
        }
        int encodingCount = charsetList.size();
        if (encodingCount > 0) {
            this.encodings = charsetList.toArray(new String[0]);
        } else {
            this.encodings = CharsetProviderICU.getAvailableNames();
            encodingCount = this.encodings.length;
        }
        PropsVectors pvec = new PropsVectors((encodingCount + 31) / 32);
        this.generateSelectorData(pvec, excludedCodePoints, mappingTypes);
    }

    public List<String> selectForString(CharSequence unicodeText) {
        int c2;
        int columns = (this.encodings.length + 31) / 32;
        int[] mask = new int[columns];
        for (int i2 = 0; i2 < columns; ++i2) {
            mask[i2] = -1;
        }
        for (int index = 0; index < unicodeText.length(); index += UTF16.getCharCount(c2)) {
            c2 = UTF16.charAt(unicodeText, index);
            int pvIndex = this.trie.getCodePointValue(c2);
            if (!this.intersectMasks(mask, pvIndex, columns)) continue;
            break;
        }
        return this.selectForMask(mask);
    }
}

