/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;

public class BookTextHolder {
    public static final BookTextHolder EMPTY = new BookTextHolder("");
    private Component component;
    private String string;

    protected BookTextHolder() {
    }

    public BookTextHolder(Component component) {
        this.component = component;
    }

    public BookTextHolder(@NotNull String string) {
        this.string = string;
    }

    public static BookTextHolder fromNetwork(RegistryFriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new BookTextHolder((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer));
        }
        return new BookTextHolder(buffer.readUtf());
    }

    public String getString() {
        return this.hasComponent() ? this.component.getString() : I18n.get((String)this.string, (Object[])new Object[0]);
    }

    public String getKey() {
        ComponentContents componentContents;
        if (this.hasComponent() && (componentContents = this.component.getContents()) instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            return contents.getKey();
        }
        return this.string;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public boolean isEmpty() {
        return (this.hasComponent() ? this.component.getString() : this.string).isEmpty();
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hasComponent());
        if (this.hasComponent()) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.component);
        } else {
            buffer.writeUtf(this.string);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookTextHolder that = (BookTextHolder)o;
        if (this.hasComponent() && that.hasComponent()) {
            return this.component.equals((Object)that.component);
        }
        if (this.string != null) {
            return this.string.equals(that.string);
        }
        return false;
    }

    public int hashCode() {
        return this.hasComponent() ? this.component.hashCode() : (this.string == null ? 0 : this.string.hashCode());
    }

    public record ScaleCacheKey(BookTextHolder holder, int width, int height) {
    }
}

