/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei;

import cy.jdkdigital.productivemetalworks.integration.jei.JeiPlugin;
import cy.jdkdigital.productivemetalworks.integration.jei.ingredient.EntityRenderer;
import cy.jdkdigital.productivemetalworks.recipe.EntityMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import java.util.Comparator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class EntityMeltingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<EntityMeltingRecipe>> {
    private final IDrawable background;

    public EntityMeltingRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.ENTITY_MELTING, (Component)Component.translatable((String)"jei.productivemetalworks.entity_melting"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MetalworksRegistrator.FOUNDRY_CONTROLLERS.get(DyeColor.BLACK).get())), 165, 68);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/jei/entity_melting.png"), 0, 0, 165, 68).setTextureSize(165, 68).build();
    }

    public void draw(RecipeHolder<EntityMeltingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        EntityRenderer.render(guiGraphics, 26, 26, ((EntityMeltingRecipe)recipe.value()).entity, Minecraft.getInstance());
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<EntityMeltingRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Entity entity;
        if (mouseX >= 8.0 && mouseX < 56.0 && mouseY >= 8.0 && mouseY < 56.0 && (entity = EntityRenderer.get(((EntityMeltingRecipe)recipe.value()).entity, Minecraft.getInstance())) != null) {
            tooltip.add((FormattedText)entity.getDisplayName());
        }
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EntityMeltingRecipe> recipe, IFocusGroup focuses) {
        int maxAmount = ((EntityMeltingRecipe)recipe.value()).result.stream().max(Comparator.comparingInt(FluidStack::getAmount)).get().getAmount();
        int fWidth = 42 / ((EntityMeltingRecipe)recipe.value()).result.size();
        for (int i = 0; i < ((EntityMeltingRecipe)recipe.value()).result.size(); ++i) {
            FluidStack fluid = ((EntityMeltingRecipe)recipe.value()).result.get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 112 + i * fWidth, 8).addFluidStack(fluid.getFluid(), (long)fluid.getAmount()).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip(fluid))).setFluidRenderer((long)maxAmount, false, fWidth, 52).setSlotName("fluid" + i);
        }
    }
}

