/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei;

import cy.jdkdigital.productivemetalworks.integration.jei.JeiPlugin;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemCastingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<ItemCastingRecipe>> {
    private final IDrawable background;

    public ItemCastingRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.ITEM_CASTING, (Component)Component.translatable((String)"jei.productivemetalworks.item_casting"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MetalworksRegistrator.CASTING_TABLE.get())), 165, 68);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/jei/item_casting.png"), 0, 0, 165, 68).setTextureSize(165, 68).build();
    }

    public void draw(RecipeHolder<ItemCastingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ItemCastingRecipe> recipe, IFocusGroup focuses) {
        boolean hasCast;
        boolean bl = hasCast = !((ItemCastingRecipe)recipe.value()).cast.isEmpty();
        if (hasCast) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 63, 26).addIngredients(((ItemCastingRecipe)recipe.value()).cast)).setSlotName("cast");
        }
        List<Fluid> fluidFocuses = focuses.getFocuses((IIngredientType)NeoForgeTypes.FLUID_STACK).map(focus -> (FluidStack)focus.getTypedValue().getIngredient()).map(FluidStack::getFluid).toList();
        List<FluidStack> fluidStacks = Arrays.stream(((ItemCastingRecipe)recipe.value()).fluid.getFluids()).filter(fluidStack -> fluidFocuses.isEmpty() || fluidFocuses.contains(fluidStack.getFluid())).filter(fluidStack -> fluidStack.getFluid().defaultFluidState().isSource()).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 26).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip((FluidStack)fluidStacks.getFirst()))).setFluidRenderer((long)((ItemCastingRecipe)recipe.value()).fluid.amount(), false, 16, 16).setSlotName("fluids_tank");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 68, 16).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip((FluidStack)fluidStacks.getFirst()))).setFluidRenderer((long)((ItemCastingRecipe)recipe.value()).fluid.amount(), false, 6, hasCast ? 10 : 26).setSlotName("fluids");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 26).addItemStack(((ItemCastingRecipe)recipe.value()).result)).setStandardSlotBackground().setSlotName("result");
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(Ingredient.of(fluidStacks.stream().map(f -> new ItemStack((ItemLike)f.getFluid().getBucket()))));
    }
}

