/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei.ingredient;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivemetalworks.common.datamap.EntityMeltingMap;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityRenderer {
    public static Map<ResourceLocation, Entity> cache = new HashMap<ResourceLocation, Entity>();

    @Nullable
    public static Entity get(ResourceLocation entityId, Minecraft minecraft) {
        return entityId.equals((Object)ResourceLocation.parse((String)"minecraft:player")) ? minecraft.player : (Entity)cache.getOrDefault(entityId, null);
    }

    public static void render(GuiGraphics guiGraphics, int xPosition, int yPosition, ResourceLocation entityId, Minecraft minecraft) {
        if (!cache.containsKey(entityId) && minecraft.level != null) {
            cache.put(entityId, ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId)).create((Level)minecraft.level));
        }
        EntityRenderer.render(guiGraphics, xPosition, yPosition, EntityRenderer.get(entityId, minecraft), minecraft);
    }

    public static void render(GuiGraphics guiGraphics, int xPosition, int yPosition, @Nullable Entity entity, Minecraft minecraft) {
        if (minecraft.player != null && entity != null) {
            EntityMeltingMap data = (EntityMeltingMap)entity.getType().builtInRegistryHolder().getData(MetalworksRegistrator.ENTITY_MELTING_MAP);
            float scaledSize = 18.0f * (data != null ? data.scale() : 1.0f);
            entity.tickCount = minecraft.player.tickCount;
            entity.setYBodyRot(-20.0f);
            PoseStack postStack = guiGraphics.pose();
            postStack.pushPose();
            postStack.translate(7.0 + (double)xPosition, 12.0 + (double)yPosition, 1.5);
            postStack.mulPose(Axis.ZP.rotationDegrees(190.0f));
            postStack.mulPose(Axis.YP.rotationDegrees(20.0f));
            postStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            postStack.translate(0.0f, -0.2f, 1.0f);
            postStack.scale(scaledSize, scaledSize, scaledSize);
            EntityRenderDispatcher entityRendererManager = minecraft.getEntityRenderDispatcher();
            MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
            entityRendererManager.render(entity, 0.0, 0.0, 0.0, (float)minecraft.getFrameTimeNs(), 1.0f, postStack, (MultiBufferSource)buffer, 0xF000F0);
            postStack.popPose();
        }
    }
}

