/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient.sorter;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;

public abstract class IngredientInstanceSorterAdapter<T>
implements IIngredientInstanceSorter<T> {
    private final IImage icon;
    private final String unlocalizedName;

    public IngredientInstanceSorterAdapter(IImage icon, String ingredientType, String kind) {
        this.icon = icon;
        this.unlocalizedName = "gui.integratedterminals.terminal_storage.sort." + ingredientType + "." + kind;
    }

    @Override
    public IImage getIcon() {
        return this.icon;
    }

    @Override
    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)Component.translatable((String)(this.unlocalizedName + ".info")).withStyle(ChatFormatting.GRAY));
    }
}

