/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.logic.compiled.CompiledDetectorModule;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.Range;

public class DetectorModuleScreen
extends ModuleScreen {
    private static final ItemStack redstoneStack = new ItemStack((ItemLike)Items.REDSTONE);
    private boolean isStrong;
    private IntegerTextField intField;

    public DetectorModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledDetectorModule cdm = new CompiledDetectorModule(null, this.moduleItemStack);
        this.intField = new IntegerTextField(this.font, this.leftPos + 152, this.topPos + 19, 20, 12, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15)));
        this.intField.setValue(cdm.getSignalLevel());
        this.intField.setResponder(str -> this.sendModuleSettingsDelayed(5));
        this.intField.setIncr(1, 4);
        this.intField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.intField);
        MutableComponent label = ClientUtil.xlate("modularrouters.itemText.misc.strongSignal." + cdm.isStrongSignal(), new Object[0]);
        this.isStrong = cdm.isStrongSignal();
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.leftPos + 138, this.topPos + 33, 40, 20, (Component)label, button -> {
            this.isStrong = !this.isStrong;
            button.setMessage((Component)ClientUtil.xlate("modularrouters.itemText.misc.strongSignal." + this.isStrong, new Object[0]));
            this.sendToServer();
        }));
        this.addRenderableWidget((GuiEventListener)new TooltipButton(this.leftPos + 132, this.topPos + 15, 16, 16, redstoneStack));
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 129, this.topPos + 14, this.leftPos + 172, this.topPos + 31, "modularrouters.guiText.popup.detector.signalLevel");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 135, this.topPos + 31, this.leftPos + 180, this.topPos + 54, "modularrouters.guiText.popup.detector.weakStrong");
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(GUI_TEXTURE, this.leftPos + 148, this.topPos + 16, SMALL_TEXTFIELD_XY.x(), SMALL_TEXTFIELD_XY.y(), 21, 14);
    }

    @Override
    protected void buildComponentPatch(DataComponentPatch.Builder builder) {
        super.buildComponentPatch(builder);
        builder.set(ModDataComponents.DETECTOR_SETTINGS.get(), (Object)new CompiledDetectorModule.DetectorSettings(this.intField.getIntValue(), this.isStrong));
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            ClientUtil.setMultilineTooltip((AbstractWidget)this, new Component[]{ClientUtil.xlate("modularrouters.guiText.tooltip.detectorTooltip", new Object[0]).withStyle(ChatFormatting.AQUA), ClientUtil.xlate("modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0])});
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }
}

