/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import java.util.Map;
import me.desht.modularrouters.api.event.RegisterRouterContainerData;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.AbstractMRContainerMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class RouterMenu
extends AbstractMRContainerMenu {
    private static final int BUFFER_SLOT = 0;
    public static final int MODULE_SLOT_START = 1;
    public static final int MODULE_SLOT_END = 9;
    private static final int UPGRADE_SLOT_START = 10;
    private static final int UPGRADE_SLOT_END = 14;
    private static final int BUFFER_XPOS = 8;
    private static final int BUFFER_YPOS = 40;
    private static final int HOTBAR_XPOS = 8;
    private static final int HOTBAR_YPOS = 162;
    private static final int PLAYER_INVENTORY_XPOS = 8;
    private static final int PLAYER_INVENTORY_YPOS = 104;
    public static final int MODULE_XPOS = 8;
    private static final int MODULE_YPOS = 72;
    public static final int UPGRADE_XPOS = 80;
    private static final int UPGRADE_YPOS = 40;
    public static final int TE_FIRST_SLOT = 36;
    private static final int TE_LAST_SLOT = 50;
    private final ModularRouterBlockEntity router;
    public final ModularRouterBlockEntity.TrackedEnergy data;

    public RouterMenu(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer, extraData.readBlockPos());
    }

    public RouterMenu(int windowId, Inventory invPlayer, BlockPos routerPos) {
        super(ModMenuTypes.ROUTER_MENU.get(), windowId);
        int slot;
        this.router = (ModularRouterBlockEntity)invPlayer.player.level().getBlockEntity(routerPos, ModBlockEntities.MODULAR_ROUTER.get()).orElseThrow(() -> new IllegalStateException("router missing at " + String.valueOf(routerPos)));
        this.data = this.router.trackedEnergy;
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)invPlayer, x, 8 + 18 * x, 162));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 104 + y * 18;
                this.addSlot(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
        this.addSlot((Slot)new SlotItemHandler(this.router.getBuffer(), 0, 8, 40));
        for (slot = 0; slot < this.router.getModuleSlotCount(); ++slot) {
            this.addSlot((Slot)new InstalledModuleSlot((IItemHandler)this.router.getModules(), slot, 8 + slot * 18, 72));
        }
        for (slot = 0; slot < this.router.getUpgradeSlotCount(); ++slot) {
            this.addSlot((Slot)new InstalledUpgradeSlot(this.router.getUpgrades(), slot, 80 + slot * 18, 40));
        }
        this.addDataSlots(this.data);
        RegisterRouterContainerData event = new RegisterRouterContainerData(this.router);
        NeoForge.EVENT_BUS.post((Event)event);
        event.getData().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.addDataSlot((DataSlot)entry.getValue()));
    }

    public boolean stillValid(Player player) {
        return !this.router.isRemoved() && Vec3.atCenterOf((Vec3i)this.router.getBlockPos()).distanceToSqr(player.position()) <= 64.0;
    }

    public ItemStack quickMoveStack(Player player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.slots.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (sourceSlotIndex < 36) {
            if (sourceStack.getItem() instanceof ModuleItem ? !this.moveItemStackTo(sourceStack, 37, 46, false) : (sourceStack.getItem() instanceof UpgradeItem ? !this.moveItemStackTo(sourceStack, 46, 51, false) : !this.moveItemStackTo(sourceStack, 36, 37, false))) {
                return ItemStack.EMPTY;
            }
        } else if (sourceSlotIndex < 86) {
            if (!this.moveItemStackTo(sourceStack, 0, 35, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.print("Invalid moduleSlotIndex: " + sourceSlotIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copyOfSourceStack;
    }

    public ModularRouterBlockEntity getRouter() {
        return this.router;
    }

    public static class InstalledModuleSlot
    extends SlotItemHandler {
        InstalledModuleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }
    }

    public static class InstalledUpgradeSlot
    extends SlotItemHandler {
        public InstalledUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int getMaxStackSize(ItemStack stack) {
            int n;
            Item item = stack.getItem();
            if (item instanceof UpgradeItem) {
                UpgradeItem u = (UpgradeItem)item;
                n = u.getInstalledStackLimit();
            } else {
                n = super.getMaxStackSize(stack);
            }
            return n;
        }
    }
}

