/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.event;

import java.util.Iterator;
import me.desht.modularrouters.block.TemplateFrameBlock;
import me.desht.modularrouters.container.RouterMenu;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="modularrouters")
public class MiscEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (entity instanceof RouterFakePlayer) {
            RouterFakePlayer fakePlayer = (RouterFakePlayer)entity;
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemEntity itemEntity = (ItemEntity)iter.next();
                if (!itemEntity.isAlive()) continue;
                ItemStack excess = fakePlayer.tryInsertIntoRouter(itemEntity.getItem());
                if (excess.isEmpty()) {
                    iter.remove();
                    continue;
                }
                if (excess.getCount() >= itemEntity.getItem().getCount()) continue;
                itemEntity.setItem(excess);
            }
        }
    }

    @SubscribeEvent
    public static void onDigSpeedCheck(PlayerEvent.BreakSpeed event) {
        if (event.getState().getBlock() instanceof TemplateFrameBlock) {
            event.getPosition().flatMap(pos -> event.getEntity().level().getBlockEntity(pos, ModBlockEntities.TEMPLATE_FRAME.get())).ifPresent(te -> {
                if (te.getCamouflage() != null && te.extendedMimic()) {
                    event.setNewSpeed(event.getEntity().getDigSpeed(te.getCamouflage(), null));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        Item item = event.getCrafting().getItem();
        if (item instanceof IPlayerOwned) {
            IPlayerOwned playerOwned = (IPlayerOwned)item;
            playerOwned.setOwner(stack, event.getEntity());
        } else if (stack.getItem() instanceof ModuleItem) {
            ItemStack moduleStack = ItemStack.EMPTY;
            for (int i = 0; i < event.getInventory().getContainerSize(); ++i) {
                ItemStack s = event.getInventory().getItem(i);
                if (s.isEmpty()) continue;
                if (s.getItem() != event.getCrafting().getItem()) break;
                moduleStack = s;
            }
            if (!moduleStack.isEmpty()) {
                AugmentHandler h = new AugmentHandler(moduleStack, null);
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)h.getStackInSlot(i));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRouterMenuClose(PlayerContainerEvent.Close event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof RouterMenu) {
            RouterMenu menu = (RouterMenu)abstractContainerMenu;
            menu.getRouter().sendBlockUpdateIfNeeded();
        }
    }
}

