/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RouterSettingsMessage(boolean ecoMode, RedstoneBehaviour redstoneBehaviour, ModularRouterBlockEntity.EnergyDirection energyDirection, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RouterSettingsMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("router_settings"));
    public static final StreamCodec<FriendlyByteBuf, RouterSettingsMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, RouterSettingsMessage::ecoMode, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RedstoneBehaviour.class), RouterSettingsMessage::redstoneBehaviour, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ModularRouterBlockEntity.EnergyDirection.class), RouterSettingsMessage::energyDirection, (StreamCodec)BlockPos.STREAM_CODEC, RouterSettingsMessage::pos, RouterSettingsMessage::new);

    public static RouterSettingsMessage forRouter(ModularRouterBlockEntity router) {
        return new RouterSettingsMessage(router.getEcoMode(), router.getRedstoneBehaviour(), router.getEnergyDirection(), router.getBlockPos());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(RouterSettingsMessage message, IPayloadContext context) {
        Level level = context.player().level();
        if (level.isLoaded(message.pos())) {
            level.getBlockEntity(message.pos(), ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
                router.setRedstoneBehaviour(message.redstoneBehaviour());
                router.setEcoMode(message.ecoMode());
                router.setEnergyDirection(message.energyDirection());
            });
        }
    }
}

