/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class EnderLeadItem
extends Item {
    protected final Type type;

    public EnderLeadItem(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public boolean canLeash(Entity target) {
        return target instanceof Mob && target.isAlive() && !target.getType().is(Tags.EntityTypes.BOSSES) && !target.getType().is(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED) && !target.isRemoved() && !target.isPassenger() && target.getType().canSerialize() && this.type.test(target);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (this.canLeash((Entity)target) && !EnderLeadItem.containsEntity(stack)) {
            CompoundTag tag = new CompoundTag();
            if (!player.level().isClientSide && target.save(tag)) {
                stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                stack.set(Ench.Components.LEASHED_ENTITY_TYPE, (Object)target.getType());
                stack.set(Ench.Components.LEASHED_ENTITY_NAME, (Object)target.getDisplayName());
                target.discard();
            }
            EnderLeadItem.playSound(player);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.interactLivingEntity(stack, player, target, usedHand);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity;
        ItemStack stack = ctx.getItemInHand();
        if (!EnderLeadItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction side = ctx.getClickedFace();
        BlockState state = level.getBlockState(pos);
        Player player = ctx.getPlayer();
        InteractionHand hand = ctx.getHand();
        EnderLeadItem.playSound(player);
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        if (this.type == Type.REINFORCED && (blockEntity = level.getBlockEntity(pos)) instanceof Spawner) {
            Spawner spawner = (Spawner)blockEntity;
            EntityType<?> type = EnderLeadItem.getType(stack);
            if (type.is(Ench.Tags.BLACKLISTED_FROM_SPAWNERS)) {
                return InteractionResult.FAIL;
            }
            spawner.setEntityId(type, level.getRandom());
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            stack.remove(Ench.Components.LEASHED_ENTITY_TYPE);
            stack.remove(Ench.Components.LEASHED_ENTITY_NAME);
            stack.remove(DataComponents.ENTITY_DATA);
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(side);
        EntityType<?> type = EnderLeadItem.getType(stack);
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        tag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
        if (entity != null) {
            entity.getSelfAndPassengers().forEach(ent -> {
                entity.absMoveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity(entity);
            });
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        stack.remove(Ench.Components.LEASHED_ENTITY_TYPE);
        stack.remove(Ench.Components.LEASHED_ENTITY_NAME);
        stack.remove(DataComponents.ENTITY_DATA);
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        EntityType<?> type = EnderLeadItem.getType(stack);
        if (type != null) {
            Component name = type.getDescription();
            tooltip.add((Component)ApothicEnchanting.lang("info", "leashed_entity", name).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ApothicEnchanting.lang("info", "leash_no_entity", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    public Component getName(ItemStack stack) {
        EntityType<?> type = EnderLeadItem.getType(stack);
        if (type != null) {
            Component name = (Component)stack.getOrDefault(Ench.Components.LEASHED_ENTITY_NAME, (Object)type.getDescription());
            MobCategory cat = type.getCategory();
            ChatFormatting color = switch (cat) {
                case MobCategory.AMBIENT, MobCategory.CREATURE -> ChatFormatting.DARK_GREEN;
                case MobCategory.MONSTER -> ChatFormatting.RED;
                case MobCategory.WATER_AMBIENT, MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.WATER_CREATURE, MobCategory.AXOLOTLS -> ChatFormatting.BLUE;
                default -> ChatFormatting.WHITE;
            };
            return ApothicEnchanting.lang("info", "leashed_entity_title", super.getName(stack), Component.translatable((String)"%s", (Object[])new Object[]{name}).withStyle(color));
        }
        return super.getName(stack);
    }

    public boolean isFoil(ItemStack stack) {
        return EnderLeadItem.containsEntity(stack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private static void playSound(Player player) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    @Nullable
    private static EntityType<?> getType(ItemStack stack) {
        return (EntityType)stack.get(Ench.Components.LEASHED_ENTITY_TYPE);
    }

    private static boolean containsEntity(ItemStack stack) {
        return EnderLeadItem.getType(stack) != null;
    }

    public static enum Type implements Predicate<Entity>
    {
        FLIMSY(e -> e instanceof Animal || e instanceof AmbientCreature || e instanceof WaterAnimal),
        NORMAL(Mob.class::isInstance),
        REINFORCED(Mob.class::isInstance);

        private Predicate<Entity> predicate;

        private Type(Predicate<Entity> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(Entity input) {
            return this.predicate.test(input);
        }
    }
}

