/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnchantingStatRegistry
extends DynamicRegistry<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatRegistry INSTANCE = new EnchantingStatRegistry();
    private final Map<Block, Stats> statsPerBlock = new HashMap<Block, Stats>();

    protected EnchantingStatRegistry() {
        super(ApothicEnchanting.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(ApothicEnchanting.loc("enchanting_stats"), BlockStats.CODEC);
    }

    protected void beginReload(DynamicRegistry.ReloadType type) {
        super.beginReload(type);
        this.statsPerBlock.clear();
    }

    protected void onReload(DynamicRegistry.ReloadType type) {
        super.onReload(type);
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((Block)b, bStats.stats));
        }
    }

    public static float getEterna(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        return state.getEnchantPowerBonus(level, pos) * 2.0f;
    }

    public static float getMaxEterna(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        return ((EnchantmentStatBlock)block).getMaxEnchantingPower(state, level, pos);
    }

    public static float getQuanta(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        return ((EnchantmentStatBlock)block).getQuantaBonus(state, level, pos);
    }

    public static float getArcana(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        return ((EnchantmentStatBlock)block).getArcanaBonus(state, level, pos);
    }

    public static int getBonusClues(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.getBlock();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        return ((EnchantmentStatBlock)block).getBonusClues(state, level, pos);
    }

    public static class BlockStats
    implements CodecProvider<BlockStats> {
        public static Codec<BlockStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.list((Codec)BuiltInRegistries.BLOCK.byNameCodec()).optionalFieldOf("blocks", Collections.emptyList()).forGetter(bs -> bs.blocks), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("tag").forGetter(bs -> Optional.empty()), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("block").forGetter(bs -> Optional.empty()), (App)Stats.CODEC.fieldOf("stats").forGetter(bs -> bs.stats)).apply((Applicative)inst, BlockStats::new));
        public final List<Block> blocks = new ArrayList<Block>();
        public final Stats stats;

        public BlockStats(List<Block> blocks, Optional<TagKey<Block>> tag, Optional<Block> block, Stats stats) {
            if (!blocks.isEmpty()) {
                this.blocks.addAll(blocks);
            }
            if (tag.isPresent()) {
                this.blocks.addAll(INSTANCE.getContext().getTag(tag.get()).stream().map(Holder::value).toList());
            }
            if (block.isPresent()) {
                this.blocks.add(block.get());
            }
            this.stats = stats;
        }

        public Codec<? extends BlockStats> getCodec() {
            return CODEC;
        }
    }

    public record Stats(float maxEterna, float eterna, float quanta, float arcana, int clues) {
        public static Codec<Stats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.optionalFieldOf("maxEterna", (Object)Float.valueOf(15.0f)).forGetter(Stats::maxEterna), (App)Codec.FLOAT.optionalFieldOf("eterna", (Object)Float.valueOf(0.0f)).forGetter(Stats::eterna), (App)Codec.FLOAT.optionalFieldOf("quanta", (Object)Float.valueOf(0.0f)).forGetter(Stats::quanta), (App)Codec.FLOAT.optionalFieldOf("arcana", (Object)Float.valueOf(0.0f)).forGetter(Stats::arcana), (App)Codec.INT.optionalFieldOf("clues", (Object)0).forGetter(Stats::clues)).apply((Applicative)inst, Stats::new));
        public static StreamCodec<FriendlyByteBuf, Stats> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Stats::maxEterna, (StreamCodec)ByteBufCodecs.FLOAT, Stats::eterna, (StreamCodec)ByteBufCodecs.FLOAT, Stats::quanta, (StreamCodec)ByteBufCodecs.FLOAT, Stats::arcana, (StreamCodec)ByteBufCodecs.VAR_INT, Stats::clues, Stats::new);
    }
}

