/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.progress;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import rearth.oracle.Oracle;
import rearth.oracle.progress.OracleProgressAPI;

public class AdvancementProgressValidator {
    private static final OracleProgressAPI.ProgressValidator VALIDATOR = (bookId, entryId, validatorTarget) -> {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            Oracle.LOGGER.warn("Advancement progress validation failed: player is null");
            return false;
        }
        ResourceLocation id = ResourceLocation.parse((String)validatorTarget);
        ClientAdvancements advancementHandler = player.connection.getAdvancements();
        if (advancementHandler == null) {
            Oracle.LOGGER.warn("Advancement progress validation failed: player's advancement handler is null");
            return false;
        }
        AdvancementHolder advancementEntry = advancementHandler.get(id);
        if (advancementEntry == null) {
            return false;
        }
        AdvancementProgress advancementProgress = (AdvancementProgress)advancementHandler.progress.get(advancementEntry);
        return advancementProgress != null && advancementProgress.isDone();
    };

    public static void register() {
        OracleProgressAPI.RegisterValidator(VALIDATOR, "advancement");
    }
}

