/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.model;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CarpetedBlockModel
implements CustomBakedModel {
    private final BakedModel carpet;
    private final BlockModelShaper blockModelShaper;
    protected static boolean SINGLE_PASS = PlatHelper.getPlatform().isFabric();

    public CarpetedBlockModel(BakedModel carpet, ModelState state) {
        this.carpet = carpet;
        this.blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, @Nullable RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state == null) {
            return quads;
        }
        try {
            RenderType originalRenderType;
            BlockState mimic = (BlockState)data.get(CarpetedBlockTile.MIMIC_KEY);
            if (mimic != null && ((originalRenderType = ItemBlockRenderTypes.getChunkRenderType((BlockState)mimic)) == renderType || renderType == null || SINGLE_PASS)) {
                BakedModel model = this.blockModelShaper.getBlockModel(mimic);
                quads.addAll(model.getQuads(mimic, side, rand));
            }
        }
        catch (Exception mimic) {
            // empty catch block
        }
        if (renderType == RenderType.solid() || renderType == null || SINGLE_PASS) {
            try {
                BlockState carpetBlock = (BlockState)data.get(CarpetedBlockTile.CARPET_KEY);
                List carpetQuads = this.carpet.getQuads(state, side, rand);
                if (!carpetQuads.isEmpty()) {
                    if (carpetBlock != null) {
                        boolean occl = state.is(ModRegistry.CARPET_SLAB.get());
                        TextureAtlasSprite sprite = this.getCarpetSprite(carpetBlock);
                        BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingSprite(sprite).applyingTintIndex(16).applyingAmbientOcclusion(occl);
                        carpetQuads = transformer.transformAll(carpetQuads);
                    }
                    quads.addAll(carpetQuads);
                }
            }
            catch (Exception ignored) {
                boolean bl = true;
            }
        }
        return quads;
    }

    private TextureAtlasSprite getCarpetSprite(BlockState carpetBlock) {
        return this.blockModelShaper.getBlockModel(carpetBlock).getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(CarpetedBlockTile.MIMIC_KEY);
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.carpet.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

