/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.platform.PlatformProvider;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCRCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"NoChatReports");
    private static PlatformProvider provider = null;

    private NCRCore() {
        throw new IllegalStateException("Can't touch this");
    }

    public static PlatformProvider getProvider() {
        return provider;
    }

    public static void awaken(PlatformProvider platformProvider) {
        Preconditions.checkArgument((provider == null ? 1 : 0) != 0, (Object)"NCRCore already awake");
        provider = platformProvider;
        NCRCore.setup();
        if (provider.isOnClient()) {
            NCRCore.clientSetup();
        }
    }

    private static void setup() {
        LOGGER.debug("KONNICHIWA ZA WARUDO!");
        LOGGER.debug("Default JVM text encoding is: " + Charset.defaultCharset().displayName());
        NCRConfig.load();
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientSetup() {
        NCRClient.setup();
    }
}

