/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MineralMix
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<MineralMix>> SERIALIZER;
    public static final CachedRecipeList<MineralMix> RECIPES;
    public final List<StackWithChance> outputs;
    public final List<StackWithChance> spoils;
    public final int weight;
    public final float failChance;
    public final ImmutableSet<BiomeTagPredicate> biomeTagPredicates;
    public final Block background;

    public MineralMix(List<StackWithChance> outputs, List<StackWithChance> spoils, int weight, float failChance, Collection<BiomeTagPredicate> biomeTagPredicates, Block background) {
        super(TagOutput.EMPTY, IERecipeTypes.MINERAL_MIX);
        this.weight = weight;
        this.failChance = failChance;
        this.outputs = outputs;
        this.spoils = spoils;
        this.biomeTagPredicates = ImmutableSet.copyOf(biomeTagPredicates);
        this.background = background;
    }

    protected IERecipeSerializer<MineralMix> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    public static String getPlainName(ResourceLocation id) {
        String path = id.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getTranslationKey(ResourceLocation id) {
        return "desc.immersiveengineering.info.mineral." + MineralMix.getPlainName(id);
    }

    public ItemStack getRandomOre(Random rand) {
        float r = rand.nextFloat();
        for (StackWithChance o : this.outputs) {
            if (!(o.chance() >= 0.0f) || !((r -= o.chance()) < 0.0f)) continue;
            return o.stack().get();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getRandomSpoil(Random rand) {
        float r = rand.nextFloat();
        for (StackWithChance o : this.spoils) {
            if (!(o.chance() >= 0.0f) || !((r -= o.chance()) < 0.0f)) continue;
            return o.stack().get();
        }
        return ItemStack.EMPTY;
    }

    public boolean validBiome(Holder<Biome> biome) {
        if (this.biomeTagPredicates.isEmpty()) {
            return true;
        }
        return this.biomeTagPredicates.stream().allMatch(predicate -> predicate.test(biome));
    }

    static {
        RECIPES = new CachedRecipeList<MineralMix>(IERecipeTypes.MINERAL_MIX);
    }

    public record BiomeTagPredicate(Set<TagKey<Biome>> tags) implements Predicate<Holder<Biome>>
    {
        public BiomeTagPredicate(TagKey<Biome> singular) {
            this((Set<TagKey<Biome>>)ImmutableSet.of(singular));
        }

        @Override
        public boolean test(Holder<Biome> biomeHolder) {
            return this.tags().stream().anyMatch(arg_0 -> biomeHolder.is(arg_0));
        }
    }
}

