/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderEffectFunction;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseBalloon;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseBanner;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseBuzzsaw;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseChemthrower;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseRailgun;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseRevolver;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseShield;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ShaderRegistry {
    public static Map<ResourceLocation, ShaderRegistryEntry> shaderRegistry = new LinkedHashMap<ResourceLocation, ShaderRegistryEntry>();
    public static List<ResourceLocation> chestLootShaders = new ArrayList<ResourceLocation>();
    public static Map<Rarity, Integer> rarityWeightMap = new HashMap<Rarity, Integer>();
    public static List<Rarity> sortedRarityMap = new ArrayList<Rarity>();
    public static Multimap<UUID, ResourceLocation> receivedShaders = ArrayListMultimap.create();
    public static Map<Rarity, Integer> totalWeight = new HashMap<Rarity, Integer>();
    public static Map<UUID, Map<Rarity, Integer>> playerTotalWeight = new HashMap<UUID, Map<Rarity, Integer>>();
    public static TagKey<Item> defaultReplicationCost = IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).dust;
    public static Map<ResourceLocation, double[]> defaultLayerBounds = new HashMap<ResourceLocation, double[]>();
    public static SetRestrictedField<Function<ResourceLocation, Holder<Item>>> GET_SHADER_ITEM = SetRestrictedField.common();
    public static Set<IShaderRegistryMethod> shaderRegistrationMethods = new HashSet<IShaderRegistryMethod>();
    public static Map<Rarity, ? extends ItemLike> itemShaderBag;
    public static List<ItemStack> itemExamples;

    public static ShaderCase getShader(ResourceLocation name, ResourceLocation shaderCase) {
        if (shaderRegistry.containsKey(name)) {
            return shaderRegistry.get(name).getCase(shaderCase);
        }
        return null;
    }

    public static ShaderRegistryEntry registerShader(ResourceLocation name, String overlayType, Rarity rarity, int colourPrimary, int colourSecondary, int colourBackground, int colourBlade, String additionalTexture, int colourAdditional, boolean loot, boolean bags) {
        ShaderRegistry.registerShader_Item(name, rarity, colourBackground, colourPrimary, colourSecondary);
        ShaderRegistry.registerShader_Revolver(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Chemthrower(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Drill(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Buzzsaw(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Railgun(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Shield(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Minecart(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Balloon(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Banner(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        for (IShaderRegistryMethod method : shaderRegistrationMethods) {
            method.apply(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, additionalTexture, colourAdditional);
        }
        return shaderRegistry.get(name).setCrateLoot(loot).setBagLoot(bags).setReplicationCost(() -> new IngredientWithSize(Ingredient.of(defaultReplicationCost), 10 - rarityWeightMap.get(rarity)));
    }

    public static <T extends ShaderCase> T registerShaderCase(ResourceLocation name, T shader, Rarity rarity) {
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseItem registerShader_Item(ResourceLocation name, Rarity rarity, int colour0, int colour1, int colour2) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shader_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shader_1"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shader_2"), colour2));
        ShaderCaseItem shader = new ShaderCaseItem(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseRevolver registerShader_Revolver(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, int colour2, int colourBlade, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/revolvers/shaders/revolver_grip"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/revolvers/shaders/revolver_0"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/revolvers/shaders/revolver_0"), colourBlade));
        list.add(new ShaderLayer(IEApi.ieLoc("item/revolvers/shaders/revolver_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/revolvers/shaders/revolver_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/revolvers/shaders/revolver_uncoloured"), -1));
        ShaderCaseRevolver shader = new ShaderCaseRevolver(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseChemthrower registerShader_Chemthrower(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/chemthrower_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/chemthrower_0"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/chemthrower_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/shaders/chemthrower_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/chemthrower_uncoloured"), -1));
        ShaderCaseChemthrower shader = new ShaderCaseChemthrower(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseDrill registerShader_Drill(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/drill_diesel_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/drill_diesel_0"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/drill_diesel_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/shaders/drill_diesel_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/drill_diesel_uncoloured"), -1));
        list.add(new ShaderLayer(null, -1));
        ShaderCaseDrill shader = new ShaderCaseDrill(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseBuzzsaw registerShader_Buzzsaw(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/buzzsaw_diesel_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/buzzsaw_diesel_0"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/buzzsaw_diesel_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/shaders/buzzsaw_diesel_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/buzzsaw_diesel_uncoloured"), -1));
        list.add(new ShaderLayer(null, -1));
        ShaderCaseBuzzsaw shader = new ShaderCaseBuzzsaw(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseRailgun registerShader_Railgun(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/railgun_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/railgun_0"), colour1));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/railgun_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/shaders/railgun_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/railgun_uncoloured"), -1));
        ShaderCaseRailgun shader = new ShaderCaseRailgun(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseShield registerShader_Shield(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/shield_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/shield_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("item/shaders/shield_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("item/shaders/shield_uncoloured"), -1));
        ShaderCaseShield shader = new ShaderCaseShield(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseMinecart registerShader_Minecart(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("textures/models/shaders/minecart_0.png"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("textures/models/shaders/minecart_1_" + overlayType + ".png"), colour1));
        if (additionalTexture != null) {
            if (additionalTexture.indexOf(58) >= 0) {
                list.add(new ShaderLayer(ResourceLocation.parse((String)(additionalTexture + ".png")), colourAddtional));
            } else {
                list.add(new ShaderLayer(IEApi.ieLoc("textures/models/shaders/minecart_" + additionalTexture + ".png"), colourAddtional));
            }
        }
        list.add(new ShaderLayer(IEApi.ieLoc("textures/models/shaders/minecart_uncoloured.png"), -1));
        ShaderCaseMinecart shader = new ShaderCaseMinecart(list);
        if (overlayType.equals("1") || overlayType.equals("2") || overlayType.equals("7")) {
            shader.renderSides[1][1] = false;
            shader.renderSides[1][2] = false;
        }
        if (additionalTexture != null) {
            shader.renderSides[2][1] = false;
            shader.renderSides[2][2] = false;
        }
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseBalloon registerShader_Balloon(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/balloon_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/balloon_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("block/shaders/balloon_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/balloon_uncoloured"), -1));
        ShaderCaseBalloon shader = new ShaderCaseBalloon(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseBanner registerShader_Banner(ResourceLocation name, String overlayType, Rarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/banner_0"), colour0));
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/banner_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? ResourceLocation.parse((String)additionalTexture) : IEApi.ieLoc("block/shaders/banner_" + additionalTexture);
            list.add(new ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderLayer(IEApi.ieLoc("block/shaders/banner_uncoloured"), -1));
        ShaderCaseBanner shader = new ShaderCaseBanner(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static void addRegistrationMethod(IShaderRegistryMethod method) {
        shaderRegistrationMethods.add(method);
    }

    public static void compileWeight() {
        totalWeight.clear();
        chestLootShaders.clear();
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (entry.getIsBagLoot()) {
                int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
                for (Map.Entry<Rarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                    if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                    int i = totalWeight.containsKey(weightedRarity.getKey()) ? totalWeight.get(weightedRarity.getKey()) : 0;
                    totalWeight.put(weightedRarity.getKey(), i + entry.getWeight());
                }
            }
            if (!entry.getIsCrateLoot()) continue;
            for (int i = 0; i < entry.getWeight(); ++i) {
                chestLootShaders.add(entry.getName());
            }
        }
        sortedRarityMap.clear();
        sortedRarityMap.addAll(rarityWeightMap.keySet());
        sortedRarityMap.sort(Comparator.comparingInt(enum0 -> rarityWeightMap.get(enum0)));
    }

    public static void recalculatePlayerTotalWeight(UUID player) {
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, new HashMap());
        } else {
            playerTotalWeight.get(player).clear();
        }
        Collection received = receivedShaders.get((Object)player);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            for (Map.Entry<Rarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                int weight = playerTotalWeight.get(player).containsKey(weightedRarity.getKey()) ? playerTotalWeight.get(player).get(weightedRarity.getKey()) : 0;
                int value = entry.getWeight();
                if (received.contains(entry.getName())) {
                    value = 1;
                }
                playerTotalWeight.get(player).put(weightedRarity.getKey(), weight + value);
            }
        }
    }

    public static void markShaderReceived(UUID player, ResourceLocation shader) {
        if (!receivedShaders.get((Object)player).contains(shader)) {
            receivedShaders.put((Object)player, (Object)shader);
            ShaderRegistry.recalculatePlayerTotalWeight(player);
        }
    }

    public static ResourceLocation getRandomShader(UUID player, RandomSource rand, Rarity minRarity, boolean addToReceived) {
        int total = 0;
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, totalWeight);
        }
        total = playerTotalWeight.get(player).get(minRarity);
        ResourceLocation shader = null;
        int minWeight = rarityWeightMap.get(minRarity);
        int weight = total < 1 ? total : 1 + rand.nextInt(total);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            if (!(entry.getIsInLowerBags() ? minWeight >= entryRarityWeight : minWeight == entryRarityWeight)) continue;
            int value = entry.getWeight();
            if (receivedShaders.get((Object)player).contains(entry.getName())) {
                value = 1;
            }
            if ((weight -= value) > 0) continue;
            shader = entry.getName();
            break;
        }
        if (addToReceived) {
            ShaderRegistry.markShaderReceived(player, shader);
        }
        return shader;
    }

    public static Rarity getLowerRarity(Rarity rarity) {
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            return sortedRarityMap.get(next);
        }
        return null;
    }

    public static ArrayList<Rarity> getAllLowerRarities(Rarity rarity) {
        ArrayList<Rarity> list = new ArrayList<Rarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            list.add(sortedRarityMap.get(next));
        }
        return list;
    }

    public static ArrayList<Rarity> getHigherRarities(Rarity rarity) {
        ArrayList<Rarity> list = new ArrayList<Rarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        int lowerWeight = -1;
        for (int next = idx - 1; next >= 0; --next) {
            Rarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight || lowerWeight != -1 && rWeight < lowerWeight) continue;
            list.add(r);
            lowerWeight = rWeight;
        }
        return list;
    }

    public static ArrayList<Rarity> getAllHigherRarities(Rarity rarity) {
        ArrayList<Rarity> list = new ArrayList<Rarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx - 1; next >= 0; --next) {
            Rarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight) continue;
            list.add(r);
        }
        return list;
    }

    public static ShaderAndCase getStoredShaderAndCase(ItemStack itemStack) {
        CapabilityShader.ShaderWrapper shaderCap = (CapabilityShader.ShaderWrapper)itemStack.getCapability(CapabilityShader.ITEM);
        return shaderCap != null ? ShaderRegistry.getStoredShaderAndCase(shaderCap) : null;
    }

    public static ShaderAndCase getStoredShaderAndCase(CapabilityShader.ShaderWrapper wrapper) {
        ShaderRegistryEntry registryEntry;
        ResourceLocation shader = wrapper.getShader();
        if (shader != null && (registryEntry = shaderRegistry.get(shader)) != null) {
            return new ShaderAndCase(shader, registryEntry, registryEntry.getCase(wrapper.getShaderType()));
        }
        return null;
    }

    public static ItemStack makeShaderStack(ResourceLocation name) {
        Holder<Item> shaderItem = GET_SHADER_ITEM.get().apply(name);
        return shaderItem != null ? ((Item)shaderItem.value()).getDefaultInstance() : ItemStack.EMPTY;
    }

    static {
        itemExamples = new ArrayList<ItemStack>();
    }

    public static class ShaderRegistryEntry {
        public ResourceLocation name;
        public HashMap<ResourceLocation, ShaderCase> cases = new HashMap();
        public Rarity rarity;
        public int weight;
        public boolean isCrateLoot;
        public boolean isBagLoot;
        public boolean isInLowerBags = true;
        public String info_set;
        public String info_reference;
        public String info_details;
        public Supplier<IngredientWithSize> replicationCost;
        public IShaderEffectFunction effectFunction;
        private static final IShaderEffectFunction DEFAULT_EFFECT = (world, item, shaderType, pos, dir, scale) -> {};

        public ShaderRegistryEntry(ResourceLocation name, Rarity rarity, List<ShaderCase> cases) {
            this.name = name;
            this.rarity = rarity;
            this.weight = rarityWeightMap.get(rarity);
            for (ShaderCase sCase : cases) {
                this.cases.put(sCase.getShaderType(), sCase);
            }
        }

        public ShaderRegistryEntry(ResourceLocation name, Rarity rarity, ShaderCase ... cases) {
            this(name, rarity, Arrays.asList(cases));
        }

        public ShaderRegistryEntry addCase(ResourceLocation type, ShaderCase sCase) {
            this.cases.put(type, sCase);
            return this;
        }

        public ShaderRegistryEntry addCase(ShaderCase sCase) {
            return this.addCase(sCase.getShaderType(), sCase);
        }

        public ShaderCase getCase(ResourceLocation type) {
            return this.cases.get(type);
        }

        public List<ShaderCase> getCases() {
            return new ArrayList<ShaderCase>(this.cases.values());
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public ShaderRegistryEntry setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public int getWeight() {
            return this.weight;
        }

        public ShaderRegistryEntry setCrateLoot(boolean b) {
            this.isCrateLoot = b;
            return this;
        }

        public boolean getIsCrateLoot() {
            return this.isCrateLoot;
        }

        public ShaderRegistryEntry setBagLoot(boolean b) {
            this.isBagLoot = b;
            return this;
        }

        public boolean getIsBagLoot() {
            return this.isBagLoot;
        }

        public ShaderRegistryEntry setInLowerBags(boolean b) {
            this.isInLowerBags = b;
            return this;
        }

        public boolean getIsInLowerBags() {
            return this.isInLowerBags;
        }

        public ShaderRegistryEntry setInfo(@Nullable String set, @Nullable String reference, @Nullable String details) {
            this.info_set = set;
            this.info_reference = reference;
            this.info_details = details;
            return this;
        }

        public ShaderRegistryEntry setReplicationCost(@Nonnull Supplier<IngredientWithSize> replicationCost) {
            this.replicationCost = replicationCost;
            return this;
        }

        public ShaderRegistryEntry setEffectFunction(@Nonnull IShaderEffectFunction effectFunction) {
            this.effectFunction = effectFunction;
            return this;
        }

        @Nonnull
        public IShaderEffectFunction getEffectFunction() {
            if (this.effectFunction != null) {
                return this.effectFunction;
            }
            return DEFAULT_EFFECT;
        }

        public Holder<Item> getItem() {
            return GET_SHADER_ITEM.get().apply(this.name);
        }
    }

    public static interface IShaderRegistryMethod<T extends ShaderCase> {
        public T apply(ResourceLocation var1, String var2, Rarity var3, int var4, int var5, int var6, int var7, String var8, int var9);
    }

    public record ShaderAndCase(ResourceLocation shader, ShaderRegistryEntry registryEntry, ShaderCase sCase) {
    }
}

