/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.data.loading.DatagenModLoader;

public class SetRestrictedField<T>
implements Supplier<T> {
    private static final InitializationTracker CLIENT_FIELDS = new InitializationTracker();
    private static final InitializationTracker COMMON_FIELDS = new InitializationTracker();
    private final InitializationTracker tracker;
    private T value;

    private SetRestrictedField(InitializationTracker tracker) {
        this.tracker = tracker;
    }

    public static <T> SetRestrictedField<T> client() {
        return CLIENT_FIELDS.make();
    }

    public static <T> SetRestrictedField<T> common() {
        return COMMON_FIELDS.make();
    }

    public static void lock(boolean client) {
        if (client) {
            CLIENT_FIELDS.lock();
        } else {
            COMMON_FIELDS.lock();
        }
    }

    public static void startInitializing(boolean client) {
        if (client) {
            CLIENT_FIELDS.startInitialization();
        } else {
            COMMON_FIELDS.startInitialization();
        }
    }

    public void setValue(T value) {
        Preconditions.checkState((this.tracker.state == TrackerState.INITIALIZING ? 1 : 0) != 0);
        String currentMod = ModLoadingContext.get().getActiveNamespace();
        Preconditions.checkState((DatagenModLoader.isRunningDataGen() || "immersiveengineering".equals(currentMod) ? 1 : 0) != 0, (String)"Restricted fields may only be set by Immersive Engineering, current mod is %s", (Object)currentMod);
        this.value = value;
    }

    @Override
    public T get() {
        return (T)Preconditions.checkNotNull(this.value);
    }

    public boolean isInitialized() {
        return this.value != null;
    }

    private static class InitializationTracker {
        private final List<Pair<Exception, SetRestrictedField<?>>> fields = new ArrayList();
        private TrackerState state = TrackerState.OPEN;

        private InitializationTracker() {
        }

        synchronized <T> SetRestrictedField<T> make() {
            Preconditions.checkState((this.state != TrackerState.LOCKED ? 1 : 0) != 0);
            SetRestrictedField result = new SetRestrictedField(this);
            this.fields.add(Pair.of((Object)new RuntimeException("Field created here"), result));
            return result;
        }

        public void startInitialization() {
            Preconditions.checkState((this.state == TrackerState.OPEN ? 1 : 0) != 0);
            this.state = TrackerState.INITIALIZING;
        }

        void lock() {
            Preconditions.checkState((this.state == TrackerState.INITIALIZING ? 1 : 0) != 0);
            for (Pair<Exception, SetRestrictedField<?>> field : this.fields) {
                if (((SetRestrictedField)field.getSecond()).isInitialized()) continue;
                throw new RuntimeException((Throwable)field.getFirst());
            }
            this.state = TrackerState.LOCKED;
        }
    }

    private static enum TrackerState {
        OPEN,
        INITIALIZING,
        LOCKED;

    }
}

