/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.proxy;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class IICProxy
implements IImmersiveConnectable {
    private final Level world;
    private final BlockPos pos;
    private final List<Connection> internalConns;
    private final List<ConnectionPoint> points;

    public IICProxy(Level world, BlockPos pos, Collection<Connection> internal, Collection<ConnectionPoint> points) {
        this.world = world;
        this.pos = pos;
        this.internalConns = new ArrayList<Connection>(internal);
        this.points = new ArrayList<ConnectionPoint>(points);
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return this.internalConns;
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        BlockEntity te = this.world.getBlockEntity(this.pos);
        if (!(te instanceof IImmersiveConnectable)) {
            return;
        }
        ((IImmersiveConnectable)te).removeCable(connection, attachedPoint);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return null;
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.points;
    }

    public static IICProxy readFromNBT(Level world, CompoundTag nbt) {
        ListTag internalNBT = nbt.getList("internal", 10);
        ArrayList<Connection> internal = new ArrayList<Connection>(internalNBT.size());
        for (Tag c : internalNBT) {
            internal.add(new Connection((CompoundTag)c));
        }
        ListTag pointNBT = nbt.getList("points", 10);
        ArrayList<ConnectionPoint> points = new ArrayList<ConnectionPoint>();
        for (Tag c : pointNBT) {
            points.add(new ConnectionPoint((CompoundTag)c));
        }
        return new IICProxy(world, (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos").orElseThrow(), internal, points);
    }

    public CompoundTag writeToNBT() {
        CompoundTag ret = new CompoundTag();
        ret.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        ListTag points = new ListTag();
        for (ConnectionPoint cp : this.points) {
            points.add((Object)cp.createTag());
        }
        ret.put("points", (Tag)points);
        ListTag internal = new ListTag();
        for (Connection conn : this.internalConns) {
            internal.add((Object)conn.toNBT());
        }
        ret.put("internal", (Tag)internal);
        return ret;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.pos;
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }
}

