/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BasicConveyorRender<T extends ConveyorBase>
implements IConveyorModelRender<T> {
    private final ResourceLocation active;
    private final ResourceLocation inactive;

    public BasicConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        this.active = active;
        this.inactive = inactive;
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return this.active;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return this.inactive;
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<T> context, @Nullable RenderType renderType) {
        this.addCoverToQuads(baseModel, context, renderType);
        return baseModel;
    }

    protected void addCoverToQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<T> context, @Nullable RenderType type) {
        Block cover = context.getCover();
        if (cover == Blocks.AIR) {
            return;
        }
        Function<Direction, TextureAtlasSprite> getSprite = BasicConveyorRender.makeCoverTextureGetter(cover, type);
        if (getSprite == null) {
            return;
        }
        Direction facing = context.getFacing();
        ConveyorHandler.ConveyorDirection conDir = context.getConveyorDirection();
        Function<Direction, TextureAtlasSprite> getSpriteHorizontal = f -> f.getAxis() == Direction.Axis.Y ? null : (TextureAtlasSprite)getSprite.apply((Direction)f);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(facing);
        Function<Vec3[], Vec3[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
            Vec3[] ret = new Vec3[((Vec3[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3(vertices[i].x, vertices[i].y + (double)(vertices[i].z == (double)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].z);
            }
            return ret;
        };
        baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.75, 0.0), new Vec3(1.0, 1.0, 1.0), matrix, facing, vertexTransformer, getSprite, colour));
        if (this.shouldRenderWall(facing, ConveyorWall.LEFT, context)) {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.0), new Vec3(0.0625, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
        } else {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.0), new Vec3(0.0625, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0625, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
        }
        if (this.shouldRenderWall(facing, ConveyorWall.RIGHT, context)) {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.0), new Vec3(1.0, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
        } else {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.0), new Vec3(1.0, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.9375), new Vec3(1.0, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
        }
    }

    @Nullable
    protected static Function<Direction, TextureAtlasSprite> makeCoverTextureGetter(Block cover, @Nullable RenderType layer) {
        ChunkRenderTypeSet modelLayers;
        BlockState state = cover.defaultBlockState();
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state);
        if (layer != null && ((modelLayers = model.getRenderTypes(state, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY)).isEmpty() || modelLayers.iterator().next() != layer)) {
            return null;
        }
        TextureAtlasSprite sprite = model.getParticleIcon(ModelData.EMPTY);
        EnumMap<Direction, TextureAtlasSprite> sprites = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
        for (Direction f : DirectionUtils.VALUES) {
            for (BakedQuad q : model.getQuads(state, f, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null)) {
                if (q == null || q.getSprite() == null) continue;
                sprites.put(f, q.getSprite());
            }
        }
        for (BakedQuad q : model.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null)) {
            if (q == null || q.getSprite() == null || q.getDirection() == null) continue;
            sprites.put(q.getDirection(), q.getSprite());
        }
        return d -> sprites.getOrDefault(d, sprite);
    }
}

