/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.entities.illager.Bulwark;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractIllager;

public class BulwarkRenderer
extends IllagerRenderer<Bulwark> {
    private static final ResourceLocation TEXTURE = IEApi.ieLoc("textures/entity/illager/bulwark.png");

    public BulwarkRenderer(EntityRendererProvider.Context p_174354_) {
        super(p_174354_, (IllagerModel)new IllagerModel<Bulwark>(BulwarkRenderer.createBodyLayer().bakeRoot()){

            public void setupAnim(Bulwark entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.setupAnim((AbstractIllager)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                boolean isLefthanded = entity.isLeftHanded();
                ModelPart rightArm = this.root().getChild("right_arm");
                ModelPart leftArm = this.root().getChild("left_arm");
                ModelPart head = this.root().getChild("head");
                if (entity.isBlocking()) {
                    if (isLefthanded) {
                        rightArm.xRot = rightArm.xRot * 0.5f - 1.11701f;
                        rightArm.yRot = -0.7853982f;
                    } else {
                        leftArm.xRot = leftArm.xRot * 0.5f - 1.11701f;
                        leftArm.yRot = 0.7853982f;
                    }
                }
                if (isLefthanded) {
                    leftArm.xRot = -0.523599f;
                } else {
                    rightArm.xRot = -0.523599f;
                }
            }
        }, 0.5f);
        ((IllagerModel)this.model).getHat().visible = true;
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, p_174354_.getItemInHandRenderer()));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition1.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        arms.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(44, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(44, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(28, 40).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(44, 40).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(28, 40).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(44, 40).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ResourceLocation getTextureLocation(Bulwark entity) {
        return TEXTURE;
    }
}

