/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class TurretRenderer
extends IEBlockEntityRenderer<TurretBlockEntity<?>> {
    public static final Map<IEBlocks.BlockEntry<?>, String> MODEL_NAME_BY_BLOCK = ImmutableMap.of(IEBlocks.MetalDevices.TURRET_CHEM, (Object)"turret_chem", IEBlocks.MetalDevices.TURRET_GUN, (Object)"turret_gun");
    public static final Map<IEBlocks.BlockEntry<?>, String> MODEL_FILE_BY_BLOCK = ImmutableMap.of(IEBlocks.MetalDevices.TURRET_CHEM, (Object)"block/metal_device/chem_turret.obj.ie", IEBlocks.MetalDevices.TURRET_GUN, (Object)"block/metal_device/gun_turret.obj.ie");
    private static final Map<ResourceLocation, DynamicModel> MODELS_BY_BLOCK = new HashMap<ResourceLocation, DynamicModel>();

    public void render(TurretBlockEntity<?> tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().hasChunkAt(tile.getBlockPos())) {
            return;
        }
        BlockState state = tile.getBlockState();
        if (state.getBlock() != IEBlocks.MetalDevices.TURRET_CHEM.get() && state.getBlock() != IEBlocks.MetalDevices.TURRET_GUN.get()) {
            return;
        }
        BakedModel model = MODELS_BY_BLOCK.get(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock())).get();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        float defaultYaw = 180.0f - tile.getFacing().toYRot();
        matrixStack.mulPose(new Quaternionf().rotateY((tile.rotationYaw + defaultYaw) * ((float)Math.PI / 180)).rotateX(-tile.rotationPitch * ((float)Math.PI / 180)));
        TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getLevelNonnull(), state, model, tile.getBlockPos(), true, combinedLightIn, "gun");
        if (tile instanceof TurretGunBlockEntity) {
            TurretGunBlockEntity gunTurret = (TurretGunBlockEntity)tile;
            if (gunTurret.cycleRender > 0) {
                float cycle = 0.0f;
                cycle = gunTurret.cycleRender > 3 ? (float)(5 - gunTurret.cycleRender) / 2.0f : (float)gunTurret.cycleRender / 3.0f;
                matrixStack.translate(0.0, 0.0, (double)cycle * 0.3125);
            }
            TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getLevelNonnull(), state, model, tile.getBlockPos(), false, combinedLightIn, "action");
        }
        matrixStack.popPose();
    }

    public static void renderModelPart(MultiBufferSource buffer, PoseStack matrix, Level world, BlockState state, BakedModel model, BlockPos pos, boolean isFirst, int light, String ... parts) {
        pos = pos.above();
        VertexConsumer solidBuilder = buffer.getBuffer(RenderType.solid());
        matrix.pushPose();
        matrix.translate(-0.5, 0.0, -0.5);
        List quads = model.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts)), RenderType.solid());
        RenderUtils.renderModelTESRFancy(quads, solidBuilder, matrix, world, pos, !isFirst, -1, light);
        matrix.popPose();
    }

    public static void fillModels() {
        MODEL_NAME_BY_BLOCK.forEach((key, value) -> MODELS_BY_BLOCK.put(key.getId(), new DynamicModel((String)value)));
    }

    public AABB getRenderBoundingBox(TurretBlockEntity<?> turret) {
        if (turret.renderBB == null) {
            turret.renderBB = new AABB(new Vec3(-8.0, -8.0, -8.0), new Vec3(8.0, 8.0, 8.0)).move(turret.getBlockPos());
        }
        return turret.renderBB;
    }
}

