/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.DieselGeneratorLogic;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DieselGeneratorShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new DieselGeneratorShapes();
    public static final Function<BlockPos, VoxelShape> GETTER_WITH_REDSTONE_SUPPORT = DieselGeneratorShapes::redstoneSupported;

    private DieselGeneratorShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (new BlockPos(1, 1, 4).equals((Object)posInMultiblock)) {
            return Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape)Shapes.box((double)0.0, (double)-0.5, (double)-0.625, (double)1.0, (double)0.5, (double)1.0));
        }
        if (posInMultiblock.getY() == 1 && posInMultiblock.getZ() == 4) {
            return ShapeUtils.join(Utils.flipBoxes(false, posInMultiblock.getX() == 2, new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AABB(0.125, 0.0, 0.125, 0.375, 0.5, 0.375), new AABB(0.125, 0.0, 0.625, 0.375, 0.5, 0.875)));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.or((VoxelShape)DieselGeneratorShapes.getBlockBounds(posInMultiblock), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.5, (double)0.25, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875), Shapes.box((double)0.6875, (double)-0.5, (double)0.4375, (double)0.8125, (double)0.25, (double)0.5625)});
        }
        if (posInMultiblock.getX() % 2 == 0 && posInMultiblock.getY() == 0 && posInMultiblock.getZ() < 4) {
            double offset;
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{DieselGeneratorShapes.getBlockBounds(posInMultiblock).bounds()});
            if (posInMultiblock.getZ() > 2) {
                list.add(new AABB(0.125, 0.5625, 0.25, 1.0, 0.8125, 0.5));
                list.add(new AABB(0.125, 0.5625, 0.5, 0.375, 0.8125, 1.0));
            } else if (posInMultiblock.getZ() > 0) {
                offset = posInMultiblock.getZ() > 1 ? 0.0 : 1.0;
                list.add(new AABB(0.4375, 0.5, -0.5625 + offset, 1.0, 1.0, 0.75 + offset));
            }
            if (posInMultiblock.getZ() < 2) {
                offset = posInMultiblock.getZ() == 1 ? 0.0 : 1.0;
                list.add(new AABB(0.375, 0.5625, 0.5625 + offset, 0.4375, 0.8125, 0.8125 + offset));
                list.add(new AABB(0.375, 0.5625, -0.875 + offset, 0.5, 0.8125, -0.625 + offset));
                list.add(new AABB(0.125, 0.5625, -0.875 + offset, 0.375, 0.8125, 0.8125 + offset));
            }
            return ShapeUtils.join(Utils.flipBoxes(false, posInMultiblock.getX() == 2, list));
        }
        return DieselGeneratorShapes.getBlockBounds(posInMultiblock);
    }

    private static VoxelShape getBlockBounds(BlockPos posInMultiblock) {
        boolean lessThan21;
        if (new BlockPos(1, 0, 4).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.5, (double)-0.625, (double)1.0, (double)1.5, (double)1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 4), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)(posInMultiblock.getY() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.getZ() == 0 ? 1.125 : 1.0));
        }
        if (ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(0, 2, 0)).contains((Object)posInMultiblock)) {
            return Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)(posInMultiblock.getY() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.getZ() == 0 ? 1.125 : 1.0));
        }
        if (new BlockPos(1, 2, 0).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(posInMultiblock.getY() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.getZ() == 0 ? 0.625 : 1.0));
        }
        if (posInMultiblock.getY() == 1 && posInMultiblock.getZ() == 4) {
            return Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (posInMultiblock.getX() == 1 && posInMultiblock.getY() > 0 && posInMultiblock.getZ() == 3) {
            return Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)(posInMultiblock.getY() == 2 ? 0.3125 : 1.0), (double)0.625);
        }
        if (new BoundingBox(1, 2, 1, 1, 2, 2).isInside((Vec3i)posInMultiblock)) {
            return Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.3125, (double)1.0);
        }
        if (posInMultiblock.getX() % 2 == 0 && posInMultiblock.getY() == 0) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        boolean bl = lessThan21 = posInMultiblock.getY() == 0 || posInMultiblock.getY() == 1 && posInMultiblock.getZ() > 2;
        if (posInMultiblock.getX() == 0 && posInMultiblock.getY() < 2) {
            return Shapes.box((double)0.9375, (double)-0.5, (double)0.0, (double)1.0, (double)0.625, (double)(lessThan21 ? 0.625 : 1.0));
        }
        if (posInMultiblock.getX() == 2 && posInMultiblock.getY() < 2) {
            return Shapes.box((double)0.0, (double)-0.5, (double)0.0, (double)0.0625, (double)0.625, (double)(lessThan21 ? 0.625 : 1.0));
        }
        if (posInMultiblock.getX() % 2 == 0 && posInMultiblock.getY() == 2 && posInMultiblock.getZ() == 2) {
            return Shapes.create((AABB)Utils.flipBox(false, posInMultiblock.getX() == 2, new AABB(0.5625, 0.0, -0.0625, 1.0625, posInMultiblock.getX() == 2 ? 1.125 : 0.75, 0.4375)));
        }
        return Shapes.block();
    }

    private static VoxelShape redstoneSupported(BlockPos pos) {
        VoxelShape baseShape = SHAPE_GETTER.apply(pos);
        if (pos.equals((Object)DieselGeneratorLogic.REDSTONE_POS)) {
            return Shapes.or((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        }
        return baseShape;
    }
}

