/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SlagGravelBlock
extends FallingBlock {
    public SlagGravelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return MapCodec.unit((Object)((Object)this));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        BlockPos posTopPlant = null;
        while (stateAbove.getFluidState().is(FluidTags.WATER) && stateAbove.getBlock() instanceof BonemealableBlock) {
            posTopPlant = posAbove;
            posAbove = posAbove.above();
            stateAbove = level.getBlockState(posAbove);
        }
        if (posTopPlant != null) {
            level.getBlockState(posTopPlant).randomTick(level, posTopPlant, rand);
        }
    }
}

